package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelStatusBuilder extends ParallelStatusFluentImpl<ParallelStatusBuilder> implements VisitableBuilder<ParallelStatus,ParallelStatusBuilder>{

    ParallelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelStatusBuilder(){
            this(true);
    }
    public ParallelStatusBuilder(Boolean validationEnabled){
            this(new ParallelStatus(), validationEnabled);
    }
    public ParallelStatusBuilder(ParallelStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelStatus(), validationEnabled);
    }
    public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,ParallelStatus instance){
            this(fluent, instance, true);
    }
    public ParallelStatusBuilder(ParallelStatusFluent<?> fluent,ParallelStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withBranchStatuses(instance.getBranchStatuses()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withIngressChannelStatus(instance.getIngressChannelStatus()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelStatusBuilder(ParallelStatus instance){
            this(instance,true);
    }
    public ParallelStatusBuilder(ParallelStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withBranchStatuses(instance.getBranchStatuses()); 
            this.withConditions(instance.getConditions()); 
            this.withIngressChannelStatus(instance.getIngressChannelStatus()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelStatus build(){
            ParallelStatus buildable = new ParallelStatus(fluent.getAddress(),fluent.getBranchStatuses(),fluent.getConditions(),fluent.getIngressChannelStatus(),fluent.getObservedGeneration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelStatusBuilder that = (ParallelStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
