package io.fabric8.knative.legacysources.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface ApiServerSourceFluent<A extends ApiServerSourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildDeprecated instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Deprecated getDeprecated();
    public Deprecated buildDeprecated();
    public A withDeprecated(Deprecated deprecated);
    public Boolean hasDeprecated();
    public ApiServerSourceFluent.DeprecatedNested<A> withNewDeprecated();
    public ApiServerSourceFluent.DeprecatedNested<A> withNewDeprecatedLike(Deprecated item);
    public ApiServerSourceFluent.DeprecatedNested<A> editDeprecated();
    public ApiServerSourceFluent.DeprecatedNested<A> editOrNewDeprecated();
    public ApiServerSourceFluent.DeprecatedNested<A> editOrNewDeprecatedLike(Deprecated item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ApiServerSourceFluent.MetadataNested<A> withNewMetadata();
    public ApiServerSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ApiServerSourceFluent.MetadataNested<A> editMetadata();
    public ApiServerSourceFluent.MetadataNested<A> editOrNewMetadata();
    public ApiServerSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ApiServerSourceSpec getSpec();
    public ApiServerSourceSpec buildSpec();
    public A withSpec(ApiServerSourceSpec spec);
    public Boolean hasSpec();
    public ApiServerSourceFluent.SpecNested<A> withNewSpec();
    public ApiServerSourceFluent.SpecNested<A> withNewSpecLike(ApiServerSourceSpec item);
    public ApiServerSourceFluent.SpecNested<A> editSpec();
    public ApiServerSourceFluent.SpecNested<A> editOrNewSpec();
    public ApiServerSourceFluent.SpecNested<A> editOrNewSpecLike(ApiServerSourceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ApiServerSourceStatus getStatus();
    public ApiServerSourceStatus buildStatus();
    public A withStatus(ApiServerSourceStatus status);
    public Boolean hasStatus();
    public ApiServerSourceFluent.StatusNested<A> withNewStatus();
    public ApiServerSourceFluent.StatusNested<A> withNewStatusLike(ApiServerSourceStatus item);
    public ApiServerSourceFluent.StatusNested<A> editStatus();
    public ApiServerSourceFluent.StatusNested<A> editOrNewStatus();
    public ApiServerSourceFluent.StatusNested<A> editOrNewStatusLike(ApiServerSourceStatus item);

    public interface DeprecatedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeprecatedFluent<ApiServerSourceFluent.DeprecatedNested<N>>{

        
    public N and();    public N endDeprecated();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ApiServerSourceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ApiServerSourceSpecFluent<ApiServerSourceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ApiServerSourceStatusFluent<ApiServerSourceFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
