package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.knative.duck.v1beta1.Destination;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.knative.duck.v1beta1.DestinationBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.knative.duck.v1beta1.DestinationFluentImpl;
import java.lang.Boolean;

public class CronJobSourceSpecFluentImpl<A extends CronJobSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CronJobSourceSpecFluent<A>{

    private String data;
    private CronJobResourceSpecBuilder resources;
    private String schedule;
    private String serviceAccountName;
    private io.fabric8.knative.duck.v1beta1.DestinationBuilder sink;

    public CronJobSourceSpecFluentImpl(){
    }
    public CronJobSourceSpecFluentImpl(CronJobSourceSpec instance){
            this.withData(instance.getData()); 
            this.withResources(instance.getResources()); 
            this.withSchedule(instance.getSchedule()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withSink(instance.getSink()); 
    }

    public String getData(){
            return this.data;
    }

    public A withData(String data){
            this.data=data; return (A) this;
    }

    public Boolean hasData(){
            return this.data != null;
    }

    public A withNewData(String arg1){
            return (A)withData(new String(arg1));
    }

    public A withNewData(StringBuilder arg1){
            return (A)withData(new String(arg1));
    }

    public A withNewData(StringBuffer arg1){
            return (A)withData(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public CronJobResourceSpec getResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public CronJobResourceSpec buildResources(){
            return this.resources!=null?this.resources.build():null;
    }

    public A withResources(CronJobResourceSpec resources){
            _visitables.get("resources").remove(this.resources);
            if (resources!=null){ this.resources= new CronJobResourceSpecBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    public CronJobSourceSpecFluent.ResourcesNested<A> withNewResources(){
            return new ResourcesNestedImpl();
    }

    public CronJobSourceSpecFluent.ResourcesNested<A> withNewResourcesLike(CronJobResourceSpec item){
            return new ResourcesNestedImpl(item);
    }

    public CronJobSourceSpecFluent.ResourcesNested<A> editResources(){
            return withNewResourcesLike(getResources());
    }

    public CronJobSourceSpecFluent.ResourcesNested<A> editOrNewResources(){
            return withNewResourcesLike(getResources() != null ? getResources(): new CronJobResourceSpecBuilder().build());
    }

    public CronJobSourceSpecFluent.ResourcesNested<A> editOrNewResourcesLike(CronJobResourceSpec item){
            return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public String getSchedule(){
            return this.schedule;
    }

    public A withSchedule(String schedule){
            this.schedule=schedule; return (A) this;
    }

    public Boolean hasSchedule(){
            return this.schedule != null;
    }

    public A withNewSchedule(String arg1){
            return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuilder arg1){
            return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuffer arg1){
            return (A)withSchedule(new String(arg1));
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.duck.v1beta1.Destination getSink(){
            return this.sink!=null?this.sink.build():null;
    }

    public io.fabric8.knative.duck.v1beta1.Destination buildSink(){
            return this.sink!=null?this.sink.build():null;
    }

    public A withSink(io.fabric8.knative.duck.v1beta1.Destination sink){
            _visitables.get("sink").remove(this.sink);
            if (sink!=null){ this.sink= new io.fabric8.knative.duck.v1beta1.DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink(){
            return this.sink != null;
    }

    public CronJobSourceSpecFluent.V1beta1SinkNested<A> withNewV1beta1Sink(){
            return new V1beta1SinkNestedImpl();
    }

    public CronJobSourceSpecFluent.V1beta1SinkNested<A> withNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item){
            return new V1beta1SinkNestedImpl(item);
    }

    public CronJobSourceSpecFluent.V1beta1SinkNested<A> editV1beta1Sink(){
            return withNewSinkLike(getSink());
    }

    public CronJobSourceSpecFluent.V1beta1SinkNested<A> editOrNewSink(){
            return withNewSinkLike(getSink() != null ? getSink(): new io.fabric8.knative.duck.v1beta1.DestinationBuilder().build());
    }

    public CronJobSourceSpecFluent.V1beta1SinkNested<A> editOrNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item){
            return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CronJobSourceSpecFluentImpl that = (CronJobSourceSpecFluentImpl) o;
            if (data != null ? !data.equals(that.data) :that.data != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
            return true;
    }


    public class ResourcesNestedImpl<N> extends CronJobResourceSpecFluentImpl<CronJobSourceSpecFluent.ResourcesNested<N>> implements CronJobSourceSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CronJobResourceSpecBuilder builder;
    
            ResourcesNestedImpl(CronJobResourceSpec item){
                    this.builder = new CronJobResourceSpecBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.builder = new CronJobResourceSpecBuilder(this);
            }
    
    public N and(){
            return (N) CronJobSourceSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources(){
            return and();
    }

}
    public class V1beta1SinkNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.DestinationFluentImpl<CronJobSourceSpecFluent.V1beta1SinkNested<N>> implements CronJobSourceSpecFluent.V1beta1SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.DestinationBuilder builder;
    
            V1beta1SinkNestedImpl(io.fabric8.knative.duck.v1beta1.Destination item){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DestinationBuilder(this, item);
            }
            V1beta1SinkNestedImpl(){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DestinationBuilder(this);
            }
    
    public N and(){
            return (N) CronJobSourceSpecFluentImpl.this.withSink(builder.build());
    }
    public N endV1beta1Sink(){
            return and();
    }

}


}
