package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReleaseTypeBuilder extends ReleaseTypeFluentImpl<ReleaseTypeBuilder> implements VisitableBuilder<ReleaseType,ReleaseTypeBuilder>{

    ReleaseTypeFluent<?> fluent;
    Boolean validationEnabled;

    public ReleaseTypeBuilder(){
            this(true);
    }
    public ReleaseTypeBuilder(Boolean validationEnabled){
            this(new ReleaseType(), validationEnabled);
    }
    public ReleaseTypeBuilder(ReleaseTypeFluent<?> fluent){
            this(fluent, true);
    }
    public ReleaseTypeBuilder(ReleaseTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReleaseType(), validationEnabled);
    }
    public ReleaseTypeBuilder(ReleaseTypeFluent<?> fluent,ReleaseType instance){
            this(fluent, instance, true);
    }
    public ReleaseTypeBuilder(ReleaseTypeFluent<?> fluent,ReleaseType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfiguration(instance.getConfiguration()); 
            fluent.withRevisions(instance.getRevisions()); 
            fluent.withRolloutPercent(instance.getRolloutPercent()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReleaseTypeBuilder(ReleaseType instance){
            this(instance,true);
    }
    public ReleaseTypeBuilder(ReleaseType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfiguration(instance.getConfiguration()); 
            this.withRevisions(instance.getRevisions()); 
            this.withRolloutPercent(instance.getRolloutPercent()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReleaseType build(){
            ReleaseType buildable = new ReleaseType(fluent.getConfiguration(),fluent.getRevisions(),fluent.getRolloutPercent());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReleaseTypeBuilder that = (ReleaseTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
