package io.fabric8.knative.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KnativeSchemaBuilder extends KnativeSchemaFluentImpl<KnativeSchemaBuilder> implements VisitableBuilder<KnativeSchema,KnativeSchemaBuilder>{

    KnativeSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public KnativeSchemaBuilder(){
            this(true);
    }
    public KnativeSchemaBuilder(Boolean validationEnabled){
            this(new KnativeSchema(), validationEnabled);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KnativeSchema(), validationEnabled);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,KnativeSchema instance){
            this(fluent, instance, true);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,KnativeSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiServerResource(instance.getApiServerResource()); 
            fluent.withApiServerSource(instance.getApiServerSource()); 
            fluent.withApiServerSourceList(instance.getApiServerSourceList()); 
            fluent.withBroker(instance.getBroker()); 
            fluent.withBrokerList(instance.getBrokerList()); 
            fluent.withChannel(instance.getChannel()); 
            fluent.withChannelList(instance.getChannelList()); 
            fluent.withContainerSource(instance.getContainerSource()); 
            fluent.withContainerSourceList(instance.getContainerSourceList()); 
            fluent.withCronJobSource(instance.getCronJobSource()); 
            fluent.withCronJobSourceList(instance.getCronJobSourceList()); 
            fluent.withEventType(instance.getEventType()); 
            fluent.withEventTypeList(instance.getEventTypeList()); 
            fluent.withInMemoryChannel(instance.getInMemoryChannel()); 
            fluent.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            fluent.withParallel(instance.getParallel()); 
            fluent.withParallelBranch(instance.getParallelBranch()); 
            fluent.withParallelBranchStatus(instance.getParallelBranchStatus()); 
            fluent.withParallelChannelStatus(instance.getParallelChannelStatus()); 
            fluent.withParallelList(instance.getParallelList()); 
            fluent.withParallelSubscriptionStatus(instance.getParallelSubscriptionStatus()); 
            fluent.withSequence(instance.getSequence()); 
            fluent.withSequenceList(instance.getSequenceList()); 
            fluent.withSinkBinding(instance.getSinkBinding()); 
            fluent.withSinkBindingList(instance.getSinkBindingList()); 
            fluent.withSubscription(instance.getSubscription()); 
            fluent.withSubscriptionList(instance.getSubscriptionList()); 
            fluent.withTrigger(instance.getTrigger()); 
            fluent.withTriggerList(instance.getTriggerList()); 
            fluent.withV1Configuration(instance.getV1Configuration()); 
            fluent.withV1ConfigurationList(instance.getV1ConfigurationList()); 
            fluent.withV1Revision(instance.getV1Revision()); 
            fluent.withV1RevisionList(instance.getV1RevisionList()); 
            fluent.withV1Route(instance.getV1Route()); 
            fluent.withV1RouteList(instance.getV1RouteList()); 
            fluent.withV1Service(instance.getV1Service()); 
            fluent.withV1ServiceList(instance.getV1ServiceList()); 
            fluent.withV1alpha1ChanalableList(instance.getV1alpha1ChanalableList()); 
            fluent.withV1alpha1Channelable(instance.getV1alpha1Channelable()); 
            fluent.withV1alpha1Configuration(instance.getV1alpha1Configuration()); 
            fluent.withV1alpha1ConfigurationList(instance.getV1alpha1ConfigurationList()); 
            fluent.withV1alpha1Resource(instance.getV1alpha1Resource()); 
            fluent.withV1alpha1ResourceList(instance.getV1alpha1ResourceList()); 
            fluent.withV1alpha1Revision(instance.getV1alpha1Revision()); 
            fluent.withV1alpha1RevisionList(instance.getV1alpha1RevisionList()); 
            fluent.withV1alpha1Route(instance.getV1alpha1Route()); 
            fluent.withV1alpha1RouteList(instance.getV1alpha1RouteList()); 
            fluent.withV1alpha1Service(instance.getV1alpha1Service()); 
            fluent.withV1alpha1ServiceList(instance.getV1alpha1ServiceList()); 
            fluent.withV1alpha1Subscribable(instance.getV1alpha1Subscribable()); 
            fluent.withV1alpha1SubscribableType(instance.getV1alpha1SubscribableType()); 
            fluent.withV1alpha1SubscribableTypeList(instance.getV1alpha1SubscribableTypeList()); 
            fluent.withV1beta1BackoffPolicyType(instance.getV1beta1BackoffPolicyType()); 
            fluent.withV1beta1ChanalableList(instance.getV1beta1ChanalableList()); 
            fluent.withV1beta1Channelable(instance.getV1beta1Channelable()); 
            fluent.withV1beta1Configuration(instance.getV1beta1Configuration()); 
            fluent.withV1beta1ConfigurationList(instance.getV1beta1ConfigurationList()); 
            fluent.withV1beta1DeliverySpec(instance.getV1beta1DeliverySpec()); 
            fluent.withV1beta1Revision(instance.getV1beta1Revision()); 
            fluent.withV1beta1RevisionList(instance.getV1beta1RevisionList()); 
            fluent.withV1beta1Route(instance.getV1beta1Route()); 
            fluent.withV1beta1RouteList(instance.getV1beta1RouteList()); 
            fluent.withV1beta1Service(instance.getV1beta1Service()); 
            fluent.withV1beta1ServiceList(instance.getV1beta1ServiceList()); 
            fluent.withV1beta1Subscribable(instance.getV1beta1Subscribable()); 
            fluent.withV1beta1SubscribableList(instance.getV1beta1SubscribableList()); 
            fluent.withV1beta1SubscribableStatus(instance.getV1beta1SubscribableStatus()); 
            fluent.withV1beta1SubscriberStatus(instance.getV1beta1SubscriberStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public KnativeSchemaBuilder(KnativeSchema instance){
            this(instance,true);
    }
    public KnativeSchemaBuilder(KnativeSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiServerResource(instance.getApiServerResource()); 
            this.withApiServerSource(instance.getApiServerSource()); 
            this.withApiServerSourceList(instance.getApiServerSourceList()); 
            this.withBroker(instance.getBroker()); 
            this.withBrokerList(instance.getBrokerList()); 
            this.withChannel(instance.getChannel()); 
            this.withChannelList(instance.getChannelList()); 
            this.withContainerSource(instance.getContainerSource()); 
            this.withContainerSourceList(instance.getContainerSourceList()); 
            this.withCronJobSource(instance.getCronJobSource()); 
            this.withCronJobSourceList(instance.getCronJobSourceList()); 
            this.withEventType(instance.getEventType()); 
            this.withEventTypeList(instance.getEventTypeList()); 
            this.withInMemoryChannel(instance.getInMemoryChannel()); 
            this.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            this.withParallel(instance.getParallel()); 
            this.withParallelBranch(instance.getParallelBranch()); 
            this.withParallelBranchStatus(instance.getParallelBranchStatus()); 
            this.withParallelChannelStatus(instance.getParallelChannelStatus()); 
            this.withParallelList(instance.getParallelList()); 
            this.withParallelSubscriptionStatus(instance.getParallelSubscriptionStatus()); 
            this.withSequence(instance.getSequence()); 
            this.withSequenceList(instance.getSequenceList()); 
            this.withSinkBinding(instance.getSinkBinding()); 
            this.withSinkBindingList(instance.getSinkBindingList()); 
            this.withSubscription(instance.getSubscription()); 
            this.withSubscriptionList(instance.getSubscriptionList()); 
            this.withTrigger(instance.getTrigger()); 
            this.withTriggerList(instance.getTriggerList()); 
            this.withV1Configuration(instance.getV1Configuration()); 
            this.withV1ConfigurationList(instance.getV1ConfigurationList()); 
            this.withV1Revision(instance.getV1Revision()); 
            this.withV1RevisionList(instance.getV1RevisionList()); 
            this.withV1Route(instance.getV1Route()); 
            this.withV1RouteList(instance.getV1RouteList()); 
            this.withV1Service(instance.getV1Service()); 
            this.withV1ServiceList(instance.getV1ServiceList()); 
            this.withV1alpha1ChanalableList(instance.getV1alpha1ChanalableList()); 
            this.withV1alpha1Channelable(instance.getV1alpha1Channelable()); 
            this.withV1alpha1Configuration(instance.getV1alpha1Configuration()); 
            this.withV1alpha1ConfigurationList(instance.getV1alpha1ConfigurationList()); 
            this.withV1alpha1Resource(instance.getV1alpha1Resource()); 
            this.withV1alpha1ResourceList(instance.getV1alpha1ResourceList()); 
            this.withV1alpha1Revision(instance.getV1alpha1Revision()); 
            this.withV1alpha1RevisionList(instance.getV1alpha1RevisionList()); 
            this.withV1alpha1Route(instance.getV1alpha1Route()); 
            this.withV1alpha1RouteList(instance.getV1alpha1RouteList()); 
            this.withV1alpha1Service(instance.getV1alpha1Service()); 
            this.withV1alpha1ServiceList(instance.getV1alpha1ServiceList()); 
            this.withV1alpha1Subscribable(instance.getV1alpha1Subscribable()); 
            this.withV1alpha1SubscribableType(instance.getV1alpha1SubscribableType()); 
            this.withV1alpha1SubscribableTypeList(instance.getV1alpha1SubscribableTypeList()); 
            this.withV1beta1BackoffPolicyType(instance.getV1beta1BackoffPolicyType()); 
            this.withV1beta1ChanalableList(instance.getV1beta1ChanalableList()); 
            this.withV1beta1Channelable(instance.getV1beta1Channelable()); 
            this.withV1beta1Configuration(instance.getV1beta1Configuration()); 
            this.withV1beta1ConfigurationList(instance.getV1beta1ConfigurationList()); 
            this.withV1beta1DeliverySpec(instance.getV1beta1DeliverySpec()); 
            this.withV1beta1Revision(instance.getV1beta1Revision()); 
            this.withV1beta1RevisionList(instance.getV1beta1RevisionList()); 
            this.withV1beta1Route(instance.getV1beta1Route()); 
            this.withV1beta1RouteList(instance.getV1beta1RouteList()); 
            this.withV1beta1Service(instance.getV1beta1Service()); 
            this.withV1beta1ServiceList(instance.getV1beta1ServiceList()); 
            this.withV1beta1Subscribable(instance.getV1beta1Subscribable()); 
            this.withV1beta1SubscribableList(instance.getV1beta1SubscribableList()); 
            this.withV1beta1SubscribableStatus(instance.getV1beta1SubscribableStatus()); 
            this.withV1beta1SubscriberStatus(instance.getV1beta1SubscriberStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public KnativeSchema build(){
            KnativeSchema buildable = new KnativeSchema(fluent.getApiServerResource(),fluent.getApiServerSource(),fluent.getApiServerSourceList(),fluent.getBroker(),fluent.getBrokerList(),fluent.getChannel(),fluent.getChannelList(),fluent.getContainerSource(),fluent.getContainerSourceList(),fluent.getCronJobSource(),fluent.getCronJobSourceList(),fluent.getEventType(),fluent.getEventTypeList(),fluent.getInMemoryChannel(),fluent.getInMemoryChannelList(),fluent.getParallel(),fluent.getParallelBranch(),fluent.getParallelBranchStatus(),fluent.getParallelChannelStatus(),fluent.getParallelList(),fluent.getParallelSubscriptionStatus(),fluent.getSequence(),fluent.getSequenceList(),fluent.getSinkBinding(),fluent.getSinkBindingList(),fluent.getSubscription(),fluent.getSubscriptionList(),fluent.getTrigger(),fluent.getTriggerList(),fluent.getV1Configuration(),fluent.getV1ConfigurationList(),fluent.getV1Revision(),fluent.getV1RevisionList(),fluent.getV1Route(),fluent.getV1RouteList(),fluent.getV1Service(),fluent.getV1ServiceList(),fluent.getV1alpha1ChanalableList(),fluent.getV1alpha1Channelable(),fluent.getV1alpha1Configuration(),fluent.getV1alpha1ConfigurationList(),fluent.getV1alpha1Resource(),fluent.getV1alpha1ResourceList(),fluent.getV1alpha1Revision(),fluent.getV1alpha1RevisionList(),fluent.getV1alpha1Route(),fluent.getV1alpha1RouteList(),fluent.getV1alpha1Service(),fluent.getV1alpha1ServiceList(),fluent.getV1alpha1Subscribable(),fluent.getV1alpha1SubscribableType(),fluent.getV1alpha1SubscribableTypeList(),fluent.getV1beta1BackoffPolicyType(),fluent.getV1beta1ChanalableList(),fluent.getV1beta1Channelable(),fluent.getV1beta1Configuration(),fluent.getV1beta1ConfigurationList(),fluent.getV1beta1DeliverySpec(),fluent.getV1beta1Revision(),fluent.getV1beta1RevisionList(),fluent.getV1beta1Route(),fluent.getV1beta1RouteList(),fluent.getV1beta1Service(),fluent.getV1beta1ServiceList(),fluent.getV1beta1Subscribable(),fluent.getV1beta1SubscribableList(),fluent.getV1beta1SubscribableStatus(),fluent.getV1beta1SubscriberStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KnativeSchemaBuilder that = (KnativeSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
