package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelableStatusBuilder extends ChannelableStatusFluentImpl<ChannelableStatusBuilder> implements VisitableBuilder<ChannelableStatus,ChannelableStatusBuilder>{

    ChannelableStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelableStatusBuilder(){
            this(true);
    }
    public ChannelableStatusBuilder(Boolean validationEnabled){
            this(new ChannelableStatus(), validationEnabled);
    }
    public ChannelableStatusBuilder(ChannelableStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelableStatusBuilder(ChannelableStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ChannelableStatus(), validationEnabled);
    }
    public ChannelableStatusBuilder(ChannelableStatusFluent<?> fluent,ChannelableStatus instance){
            this(fluent, instance, true);
    }
    public ChannelableStatusBuilder(ChannelableStatusFluent<?> fluent,ChannelableStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withErrorChannel(instance.getErrorChannel()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscribableStatus(instance.getSubscribableStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelableStatusBuilder(ChannelableStatus instance){
            this(instance,true);
    }
    public ChannelableStatusBuilder(ChannelableStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withErrorChannel(instance.getErrorChannel()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribableStatus(instance.getSubscribableStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ChannelableStatus build(){
            ChannelableStatus buildable = new ChannelableStatus(fluent.getAddress(),fluent.getConditions(),fluent.getErrorChannel(),fluent.getObservedGeneration(),fluent.getSubscribableStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelableStatusBuilder that = (ChannelableStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
