package io.fabric8.knative.duck.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.v1.URL;
import io.fabric8.knative.v1.URLBuilder;
import io.fabric8.knative.v1.URLFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DestinationFluentImpl<A extends io.fabric8.knative.duck.v1beta1.DestinationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.duck.v1beta1.DestinationFluent<A>{

    private String apiVersion;
    private String kind;
    private String name;
    private String namespace;
    private ObjectReference ref;
    private URLBuilder uri;

    public DestinationFluentImpl(){
    }
    public DestinationFluentImpl(io.fabric8.knative.duck.v1beta1.Destination instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.withRef(instance.getRef()); 
            this.withUri(instance.getUri()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getNamespace(){
            return this.namespace;
    }

    public A withNamespace(String namespace){
            this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace(){
            return this.namespace != null;
    }

    public A withNewNamespace(String arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1){
            return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1){
            return (A)withNamespace(new String(arg1));
    }

    public ObjectReference getRef(){
            return this.ref;
    }

    public A withRef(ObjectReference ref){
            this.ref=ref; return (A) this;
    }

    public Boolean hasRef(){
            return this.ref != null;
    }

    
/**
 * This method has been deprecated, please use method buildUri instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public URL getUri(){
            return this.uri!=null?this.uri.build():null;
    }

    public URL buildUri(){
            return this.uri!=null?this.uri.build():null;
    }

    public A withUri(URL uri){
            _visitables.get("uri").remove(this.uri);
            if (uri!=null){ this.uri= new URLBuilder(uri); _visitables.get("uri").add(this.uri);} return (A) this;
    }

    public Boolean hasUri(){
            return this.uri != null;
    }

    public DestinationFluent.UriNested<A> withNewUri(){
            return new UriNestedImpl();
    }

    public DestinationFluent.UriNested<A> withNewUriLike(URL item){
            return new UriNestedImpl(item);
    }

    public DestinationFluent.UriNested<A> editUri(){
            return withNewUriLike(getUri());
    }

    public DestinationFluent.UriNested<A> editOrNewUri(){
            return withNewUriLike(getUri() != null ? getUri(): new URLBuilder().build());
    }

    public DestinationFluent.UriNested<A> editOrNewUriLike(URL item){
            return withNewUriLike(getUri() != null ? getUri(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DestinationFluentImpl that = (DestinationFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
            if (ref != null ? !ref.equals(that.ref) :that.ref != null) return false;
            if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
            return true;
    }


    public class UriNestedImpl<N> extends URLFluentImpl<DestinationFluent.UriNested<N>> implements DestinationFluent.UriNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final URLBuilder builder;
    
            UriNestedImpl(URL item){
                    this.builder = new URLBuilder(this, item);
            }
            UriNestedImpl(){
                    this.builder = new URLBuilder(this);
            }
    
    public N and(){
            return (N) DestinationFluentImpl.this.withUri(builder.build());
    }
    public N endUri(){
            return and();
    }

}


}
