package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class TriggerFilterFluentImpl<A extends TriggerFilterFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TriggerFilterFluent<A>{

    private Map<String,String> attributes;
    private TriggerFilterSourceAndTypeBuilder sourceAndType;

    public TriggerFilterFluentImpl(){
    }
    public TriggerFilterFluentImpl(TriggerFilter instance){
            this.withAttributes(instance.getAttributes()); 
            this.withSourceAndType(instance.getSourceAndType()); 
    }

    public A addToAttributes(String key,String value){
            if(this.attributes == null && key != null && value != null) { this.attributes = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.attributes.put(key, value);} return (A)this;
    }

    public A addToAttributes(Map<String,String> map){
            if(this.attributes == null && map != null) { this.attributes = new LinkedHashMap<String,String>(); }
            if(map != null) { this.attributes.putAll(map);} return (A)this;
    }

    public A removeFromAttributes(String key){
            if(this.attributes == null) { return (A) this; }
            if(key != null && this.attributes != null) {this.attributes.remove(key);} return (A)this;
    }

    public A removeFromAttributes(Map<String,String> map){
            if(this.attributes == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.attributes != null){this.attributes.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAttributes(){
            return this.attributes;
    }

    public A withAttributes(Map<String,String> attributes){
            if (attributes == null) { this.attributes =  null;} else {this.attributes = new LinkedHashMap<String,String>(attributes);} return (A) this;
    }

    public Boolean hasAttributes(){
            return this.attributes != null;
    }

    
/**
 * This method has been deprecated, please use method buildSourceAndType instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public TriggerFilterSourceAndType getSourceAndType(){
            return this.sourceAndType!=null?this.sourceAndType.build():null;
    }

    public TriggerFilterSourceAndType buildSourceAndType(){
            return this.sourceAndType!=null?this.sourceAndType.build():null;
    }

    public A withSourceAndType(TriggerFilterSourceAndType sourceAndType){
            _visitables.get("sourceAndType").remove(this.sourceAndType);
            if (sourceAndType!=null){ this.sourceAndType= new TriggerFilterSourceAndTypeBuilder(sourceAndType); _visitables.get("sourceAndType").add(this.sourceAndType);} return (A) this;
    }

    public Boolean hasSourceAndType(){
            return this.sourceAndType != null;
    }

    public A withNewSourceAndType(String source,String type){
            return (A)withSourceAndType(new TriggerFilterSourceAndType(source, type));
    }

    public TriggerFilterFluent.SourceAndTypeNested<A> withNewSourceAndType(){
            return new SourceAndTypeNestedImpl();
    }

    public TriggerFilterFluent.SourceAndTypeNested<A> withNewSourceAndTypeLike(TriggerFilterSourceAndType item){
            return new SourceAndTypeNestedImpl(item);
    }

    public TriggerFilterFluent.SourceAndTypeNested<A> editSourceAndType(){
            return withNewSourceAndTypeLike(getSourceAndType());
    }

    public TriggerFilterFluent.SourceAndTypeNested<A> editOrNewSourceAndType(){
            return withNewSourceAndTypeLike(getSourceAndType() != null ? getSourceAndType(): new TriggerFilterSourceAndTypeBuilder().build());
    }

    public TriggerFilterFluent.SourceAndTypeNested<A> editOrNewSourceAndTypeLike(TriggerFilterSourceAndType item){
            return withNewSourceAndTypeLike(getSourceAndType() != null ? getSourceAndType(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TriggerFilterFluentImpl that = (TriggerFilterFluentImpl) o;
            if (attributes != null ? !attributes.equals(that.attributes) :that.attributes != null) return false;
            if (sourceAndType != null ? !sourceAndType.equals(that.sourceAndType) :that.sourceAndType != null) return false;
            return true;
    }


    public class SourceAndTypeNestedImpl<N> extends TriggerFilterSourceAndTypeFluentImpl<TriggerFilterFluent.SourceAndTypeNested<N>> implements TriggerFilterFluent.SourceAndTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TriggerFilterSourceAndTypeBuilder builder;
    
            SourceAndTypeNestedImpl(TriggerFilterSourceAndType item){
                    this.builder = new TriggerFilterSourceAndTypeBuilder(this, item);
            }
            SourceAndTypeNestedImpl(){
                    this.builder = new TriggerFilterSourceAndTypeBuilder(this);
            }
    
    public N and(){
            return (N) TriggerFilterFluentImpl.this.withSourceAndType(builder.build());
    }
    public N endSourceAndType(){
            return and();
    }

}


}
