package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ParallelFluent<A extends ParallelFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ParallelFluent.MetadataNested<A> withNewMetadata();
    public ParallelFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ParallelFluent.MetadataNested<A> editMetadata();
    public ParallelFluent.MetadataNested<A> editOrNewMetadata();
    public ParallelFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ParallelSpec getSpec();
    public ParallelSpec buildSpec();
    public A withSpec(ParallelSpec spec);
    public Boolean hasSpec();
    public ParallelFluent.SpecNested<A> withNewSpec();
    public ParallelFluent.SpecNested<A> withNewSpecLike(ParallelSpec item);
    public ParallelFluent.SpecNested<A> editSpec();
    public ParallelFluent.SpecNested<A> editOrNewSpec();
    public ParallelFluent.SpecNested<A> editOrNewSpecLike(ParallelSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ParallelStatus getStatus();
    public ParallelStatus buildStatus();
    public A withStatus(ParallelStatus status);
    public Boolean hasStatus();
    public ParallelFluent.StatusNested<A> withNewStatus();
    public ParallelFluent.StatusNested<A> withNewStatusLike(ParallelStatus item);
    public ParallelFluent.StatusNested<A> editStatus();
    public ParallelFluent.StatusNested<A> editOrNewStatus();
    public ParallelFluent.StatusNested<A> editOrNewStatusLike(ParallelStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ParallelFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParallelSpecFluent<ParallelFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ParallelStatusFluent<ParallelFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
