
package io.fabric8.knative.flows.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.duck.v1.Addressable;
import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "address",
    "branchStatuses",
    "conditions",
    "ingressChannelStatus",
    "observedGeneration"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(Volume.class),
    @BuildableReference(Container.class)
})
public class ParallelStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    private Addressable address;
    /**
     * 
     * 
     */
    @JsonProperty("branchStatuses")
    private List<ParallelBranchStatus> branchStatuses = new ArrayList<ParallelBranchStatus>();
    /**
     * 
     * 
     */
    @JsonProperty("conditions")
    private List<Condition> conditions = new ArrayList<Condition>();
    /**
     * 
     * 
     */
    @JsonProperty("ingressChannelStatus")
    private ParallelChannelStatus ingressChannelStatus;
    /**
     * 
     * 
     */
    @JsonProperty("observedGeneration")
    private Long observedGeneration;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParallelStatus() {
    }

    /**
     * 
     * @param address
     * @param ingressChannelStatus
     * @param conditions
     * @param branchStatuses
     * @param observedGeneration
     */
    public ParallelStatus(Addressable address, List<ParallelBranchStatus> branchStatuses, List<Condition> conditions, ParallelChannelStatus ingressChannelStatus, Long observedGeneration) {
        this.address = address;
        this.branchStatuses = branchStatuses;
        this.conditions = conditions;
        this.ingressChannelStatus = ingressChannelStatus;
        this.observedGeneration = observedGeneration;
    }

    /**
     * 
     * 
     * @return
     *     The address
     */
    @JsonProperty("address")
    public Addressable getAddress() {
        return address;
    }

    /**
     * 
     * 
     * @param address
     *     The address
     */
    @JsonProperty("address")
    public void setAddress(Addressable address) {
        this.address = address;
    }

    /**
     * 
     * 
     * @return
     *     The branchStatuses
     */
    @JsonProperty("branchStatuses")
    public List<ParallelBranchStatus> getBranchStatuses() {
        return branchStatuses;
    }

    /**
     * 
     * 
     * @param branchStatuses
     *     The branchStatuses
     */
    @JsonProperty("branchStatuses")
    public void setBranchStatuses(List<ParallelBranchStatus> branchStatuses) {
        this.branchStatuses = branchStatuses;
    }

    /**
     * 
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<Condition> getConditions() {
        return conditions;
    }

    /**
     * 
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The ingressChannelStatus
     */
    @JsonProperty("ingressChannelStatus")
    public ParallelChannelStatus getIngressChannelStatus() {
        return ingressChannelStatus;
    }

    /**
     * 
     * 
     * @param ingressChannelStatus
     *     The ingressChannelStatus
     */
    @JsonProperty("ingressChannelStatus")
    public void setIngressChannelStatus(ParallelChannelStatus ingressChannelStatus) {
        this.ingressChannelStatus = ingressChannelStatus;
    }

    /**
     * 
     * 
     * @return
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public Long getObservedGeneration() {
        return observedGeneration;
    }

    /**
     * 
     * 
     * @param observedGeneration
     *     The observedGeneration
     */
    @JsonProperty("observedGeneration")
    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
