package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;

public class ServiceSpecFluentImpl<A extends io.fabric8.knative.serving.v1alpha1.ServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1alpha1.ServiceSpecFluent<A>{

    private Map<String,Object> build;
    private Long generation;
    private ManualTypeBuilder manual;
    private PinnedTypeBuilder pinned;
    private ReleaseTypeBuilder release;
    private io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder revisionTemplate;
    private RunLatestTypeBuilder runLatest;
    private io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder template;
    private List<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> traffic;

    public ServiceSpecFluentImpl(){
    }
    public ServiceSpecFluentImpl(io.fabric8.knative.serving.v1alpha1.ServiceSpec instance){
            this.withBuild(instance.getBuild()); 
            this.withGeneration(instance.getGeneration()); 
            this.withManual(instance.getManual()); 
            this.withPinned(instance.getPinned()); 
            this.withRelease(instance.getRelease()); 
            this.withRevisionTemplate(instance.getRevisionTemplate()); 
            this.withRunLatest(instance.getRunLatest()); 
            this.withTemplate(instance.getTemplate()); 
            this.withTraffic(instance.getTraffic()); 
    }

    public A addToBuild(String key,Object value){
            if(this.build == null && key != null && value != null) { this.build = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.build.put(key, value);} return (A)this;
    }

    public A addToBuild(Map<String,Object> map){
            if(this.build == null && map != null) { this.build = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.build.putAll(map);} return (A)this;
    }

    public A removeFromBuild(String key){
            if(this.build == null) { return (A) this; }
            if(key != null && this.build != null) {this.build.remove(key);} return (A)this;
    }

    public A removeFromBuild(Map<String,Object> map){
            if(this.build == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.build != null){this.build.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getBuild(){
            return this.build;
    }

    public A withBuild(Map<String,Object> build){
            if (build == null) { this.build =  null;} else {this.build = new LinkedHashMap<String,Object>(build);} return (A) this;
    }

    public Boolean hasBuild(){
            return this.build != null;
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    
/**
 * This method has been deprecated, please use method buildManual instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ManualType getManual(){
            return this.manual!=null?this.manual.build():null;
    }

    public ManualType buildManual(){
            return this.manual!=null?this.manual.build():null;
    }

    public A withManual(ManualType manual){
            _visitables.get("manual").remove(this.manual);
            if (manual!=null){ this.manual= new ManualTypeBuilder(manual); _visitables.get("manual").add(this.manual);} return (A) this;
    }

    public Boolean hasManual(){
            return this.manual != null;
    }

    public ServiceSpecFluent.ManualNested<A> withNewManual(){
            return new ManualNestedImpl();
    }

    public ServiceSpecFluent.ManualNested<A> withNewManualLike(ManualType item){
            return new ManualNestedImpl(item);
    }

    public ServiceSpecFluent.ManualNested<A> editManual(){
            return withNewManualLike(getManual());
    }

    public ServiceSpecFluent.ManualNested<A> editOrNewManual(){
            return withNewManualLike(getManual() != null ? getManual(): new ManualTypeBuilder().build());
    }

    public ServiceSpecFluent.ManualNested<A> editOrNewManualLike(ManualType item){
            return withNewManualLike(getManual() != null ? getManual(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPinned instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public PinnedType getPinned(){
            return this.pinned!=null?this.pinned.build():null;
    }

    public PinnedType buildPinned(){
            return this.pinned!=null?this.pinned.build():null;
    }

    public A withPinned(PinnedType pinned){
            _visitables.get("pinned").remove(this.pinned);
            if (pinned!=null){ this.pinned= new PinnedTypeBuilder(pinned); _visitables.get("pinned").add(this.pinned);} return (A) this;
    }

    public Boolean hasPinned(){
            return this.pinned != null;
    }

    public ServiceSpecFluent.PinnedNested<A> withNewPinned(){
            return new PinnedNestedImpl();
    }

    public ServiceSpecFluent.PinnedNested<A> withNewPinnedLike(PinnedType item){
            return new PinnedNestedImpl(item);
    }

    public ServiceSpecFluent.PinnedNested<A> editPinned(){
            return withNewPinnedLike(getPinned());
    }

    public ServiceSpecFluent.PinnedNested<A> editOrNewPinned(){
            return withNewPinnedLike(getPinned() != null ? getPinned(): new PinnedTypeBuilder().build());
    }

    public ServiceSpecFluent.PinnedNested<A> editOrNewPinnedLike(PinnedType item){
            return withNewPinnedLike(getPinned() != null ? getPinned(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRelease instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ReleaseType getRelease(){
            return this.release!=null?this.release.build():null;
    }

    public ReleaseType buildRelease(){
            return this.release!=null?this.release.build():null;
    }

    public A withRelease(ReleaseType release){
            _visitables.get("release").remove(this.release);
            if (release!=null){ this.release= new ReleaseTypeBuilder(release); _visitables.get("release").add(this.release);} return (A) this;
    }

    public Boolean hasRelease(){
            return this.release != null;
    }

    public ServiceSpecFluent.ReleaseNested<A> withNewRelease(){
            return new ReleaseNestedImpl();
    }

    public ServiceSpecFluent.ReleaseNested<A> withNewReleaseLike(ReleaseType item){
            return new ReleaseNestedImpl(item);
    }

    public ServiceSpecFluent.ReleaseNested<A> editRelease(){
            return withNewReleaseLike(getRelease());
    }

    public ServiceSpecFluent.ReleaseNested<A> editOrNewRelease(){
            return withNewReleaseLike(getRelease() != null ? getRelease(): new ReleaseTypeBuilder().build());
    }

    public ServiceSpecFluent.ReleaseNested<A> editOrNewReleaseLike(ReleaseType item){
            return withNewReleaseLike(getRelease() != null ? getRelease(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRevisionTemplate instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec getRevisionTemplate(){
            return this.revisionTemplate!=null?this.revisionTemplate.build():null;
    }

    public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec buildRevisionTemplate(){
            return this.revisionTemplate!=null?this.revisionTemplate.build():null;
    }

    public A withRevisionTemplate(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec revisionTemplate){
            _visitables.get("revisionTemplate").remove(this.revisionTemplate);
            if (revisionTemplate!=null){ this.revisionTemplate= new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(revisionTemplate); _visitables.get("revisionTemplate").add(this.revisionTemplate);} return (A) this;
    }

    public Boolean hasRevisionTemplate(){
            return this.revisionTemplate != null;
    }

    public ServiceSpecFluent.RevisionTemplateNested<A> withNewRevisionTemplate(){
            return new RevisionTemplateNestedImpl();
    }

    public ServiceSpecFluent.RevisionTemplateNested<A> withNewRevisionTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return new RevisionTemplateNestedImpl(item);
    }

    public ServiceSpecFluent.RevisionTemplateNested<A> editRevisionTemplate(){
            return withNewRevisionTemplateLike(getRevisionTemplate());
    }

    public ServiceSpecFluent.RevisionTemplateNested<A> editOrNewRevisionTemplate(){
            return withNewRevisionTemplateLike(getRevisionTemplate() != null ? getRevisionTemplate(): new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder().build());
    }

    public ServiceSpecFluent.RevisionTemplateNested<A> editOrNewRevisionTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return withNewRevisionTemplateLike(getRevisionTemplate() != null ? getRevisionTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRunLatest instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public RunLatestType getRunLatest(){
            return this.runLatest!=null?this.runLatest.build():null;
    }

    public RunLatestType buildRunLatest(){
            return this.runLatest!=null?this.runLatest.build():null;
    }

    public A withRunLatest(RunLatestType runLatest){
            _visitables.get("runLatest").remove(this.runLatest);
            if (runLatest!=null){ this.runLatest= new RunLatestTypeBuilder(runLatest); _visitables.get("runLatest").add(this.runLatest);} return (A) this;
    }

    public Boolean hasRunLatest(){
            return this.runLatest != null;
    }

    public ServiceSpecFluent.RunLatestNested<A> withNewRunLatest(){
            return new RunLatestNestedImpl();
    }

    public ServiceSpecFluent.RunLatestNested<A> withNewRunLatestLike(RunLatestType item){
            return new RunLatestNestedImpl(item);
    }

    public ServiceSpecFluent.RunLatestNested<A> editRunLatest(){
            return withNewRunLatestLike(getRunLatest());
    }

    public ServiceSpecFluent.RunLatestNested<A> editOrNewRunLatest(){
            return withNewRunLatestLike(getRunLatest() != null ? getRunLatest(): new RunLatestTypeBuilder().build());
    }

    public ServiceSpecFluent.RunLatestNested<A> editOrNewRunLatestLike(RunLatestType item){
            return withNewRunLatestLike(getRunLatest() != null ? getRunLatest(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public ServiceSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public ServiceSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public ServiceSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder().build());
    }

    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public A addToTraffic(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder>();}
            io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder>();}
            io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(item);
            if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
            if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
             return (A)this;
    }

    public A addToTraffic(io.fabric8.knative.serving.v1alpha1.TrafficTarget... items){
            if (this.traffic == null) {this.traffic = new ArrayList<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder>();}
            for (io.fabric8.knative.serving.v1alpha1.TrafficTarget item : items) {io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(Collection<io.fabric8.knative.serving.v1alpha1.TrafficTarget> items){
            if (this.traffic == null) {this.traffic = new ArrayList<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder>();}
            for (io.fabric8.knative.serving.v1alpha1.TrafficTarget item : items) {io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(io.fabric8.knative.serving.v1alpha1.TrafficTarget... items){
            for (io.fabric8.knative.serving.v1alpha1.TrafficTarget item : items) {io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(Collection<io.fabric8.knative.serving.v1alpha1.TrafficTarget> items){
            for (io.fabric8.knative.serving.v1alpha1.TrafficTarget item : items) {io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate){
            if (traffic == null) return (A) this;
            final Iterator<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> each = traffic.iterator();
            final List visitables = _visitables.get("traffic");
            while (each.hasNext()) {
              io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<io.fabric8.knative.serving.v1alpha1.TrafficTarget> getTraffic(){
            return build(traffic);
    }

    public List<io.fabric8.knative.serving.v1alpha1.TrafficTarget> buildTraffic(){
            return build(traffic);
    }

    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildTraffic(int index){
            return this.traffic.get(index).build();
    }

    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildFirstTraffic(){
            return this.traffic.get(0).build();
    }

    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildLastTraffic(){
            return this.traffic.get(traffic.size() - 1).build();
    }

    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate){
            for (io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate){
            for (io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTraffic(List<io.fabric8.knative.serving.v1alpha1.TrafficTarget> traffic){
            if (this.traffic != null) { _visitables.get("traffic").removeAll(this.traffic);}
            if (traffic != null) {this.traffic = new ArrayList<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder>(); for (io.fabric8.knative.serving.v1alpha1.TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = null;} return (A) this;
    }

    public A withTraffic(io.fabric8.knative.serving.v1alpha1.TrafficTarget... traffic){
            if (this.traffic != null) {this.traffic.clear();}
            if (traffic != null) {for (io.fabric8.knative.serving.v1alpha1.TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    public Boolean hasTraffic(){
            return traffic != null && !traffic.isEmpty();
    }

    public ServiceSpecFluent.TrafficNested<A> addNewTraffic(){
            return new TrafficNestedImpl();
    }

    public ServiceSpecFluent.TrafficNested<A> addNewTrafficLike(io.fabric8.knative.serving.v1alpha1.TrafficTarget item){
            return new TrafficNestedImpl(-1, item);
    }

    public ServiceSpecFluent.TrafficNested<A> setNewTrafficLike(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item){
            return new TrafficNestedImpl(index, item);
    }

    public ServiceSpecFluent.TrafficNested<A> editTraffic(int index){
            if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public ServiceSpecFluent.TrafficNested<A> editFirstTraffic(){
            if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
            return setNewTrafficLike(0, buildTraffic(0));
    }

    public ServiceSpecFluent.TrafficNested<A> editLastTraffic(){
            int index = traffic.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public ServiceSpecFluent.TrafficNested<A> editMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate){
            int index = -1;
            for (int i=0;i<traffic.size();i++) { 
            if (predicate.apply(traffic.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServiceSpecFluentImpl that = (ServiceSpecFluentImpl) o;
            if (build != null ? !build.equals(that.build) :that.build != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (manual != null ? !manual.equals(that.manual) :that.manual != null) return false;
            if (pinned != null ? !pinned.equals(that.pinned) :that.pinned != null) return false;
            if (release != null ? !release.equals(that.release) :that.release != null) return false;
            if (revisionTemplate != null ? !revisionTemplate.equals(that.revisionTemplate) :that.revisionTemplate != null) return false;
            if (runLatest != null ? !runLatest.equals(that.runLatest) :that.runLatest != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
            return true;
    }


    public class ManualNestedImpl<N> extends ManualTypeFluentImpl<ServiceSpecFluent.ManualNested<N>> implements ServiceSpecFluent.ManualNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ManualTypeBuilder builder;
    
            ManualNestedImpl(ManualType item){
                    this.builder = new ManualTypeBuilder(this, item);
            }
            ManualNestedImpl(){
                    this.builder = new ManualTypeBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withManual(builder.build());
    }
    public N endManual(){
            return and();
    }

}
    public class PinnedNestedImpl<N> extends PinnedTypeFluentImpl<ServiceSpecFluent.PinnedNested<N>> implements ServiceSpecFluent.PinnedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PinnedTypeBuilder builder;
    
            PinnedNestedImpl(PinnedType item){
                    this.builder = new PinnedTypeBuilder(this, item);
            }
            PinnedNestedImpl(){
                    this.builder = new PinnedTypeBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withPinned(builder.build());
    }
    public N endPinned(){
            return and();
    }

}
    public class ReleaseNestedImpl<N> extends ReleaseTypeFluentImpl<ServiceSpecFluent.ReleaseNested<N>> implements ServiceSpecFluent.ReleaseNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReleaseTypeBuilder builder;
    
            ReleaseNestedImpl(ReleaseType item){
                    this.builder = new ReleaseTypeBuilder(this, item);
            }
            ReleaseNestedImpl(){
                    this.builder = new ReleaseTypeBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withRelease(builder.build());
    }
    public N endRelease(){
            return and();
    }

}
    public class RevisionTemplateNestedImpl<N> extends io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecFluentImpl<ServiceSpecFluent.RevisionTemplateNested<N>> implements ServiceSpecFluent.RevisionTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder builder;
    
            RevisionTemplateNestedImpl(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this, item);
            }
            RevisionTemplateNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withRevisionTemplate(builder.build());
    }
    public N endRevisionTemplate(){
            return and();
    }

}
    public class RunLatestNestedImpl<N> extends RunLatestTypeFluentImpl<ServiceSpecFluent.RunLatestNested<N>> implements ServiceSpecFluent.RunLatestNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RunLatestTypeBuilder builder;
    
            RunLatestNestedImpl(RunLatestType item){
                    this.builder = new RunLatestTypeBuilder(this, item);
            }
            RunLatestNestedImpl(){
                    this.builder = new RunLatestTypeBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withRunLatest(builder.build());
    }
    public N endRunLatest(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecFluentImpl<ServiceSpecFluent.TemplateNested<N>> implements ServiceSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder builder;
    
            TemplateNestedImpl(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class TrafficNestedImpl<N> extends io.fabric8.knative.serving.v1alpha1.TrafficTargetFluentImpl<ServiceSpecFluent.TrafficNested<N>> implements ServiceSpecFluent.TrafficNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder builder;
        private final int index;
    
            TrafficNestedImpl(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item){
                    this.index = index;
                    this.builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(this, item);
            }
            TrafficNestedImpl(){
                    this.index = -1;
                    this.builder = new io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder(this);
            }
    
    public N and(){
            return (N) ServiceSpecFluentImpl.this.setToTraffic(index,builder.build());
    }
    public N endTraffic(){
            return and();
    }

}


}
