package io.fabric8.knative.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.net.UserinfoBuilder;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.knative.net.UserinfoFluentImpl;
import io.fabric8.knative.net.Userinfo;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class URLFluentImpl<A extends URLFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements URLFluent<A>{

    private Boolean forceQuery;
    private String fragment;
    private String host;
    private String opaque;
    private String path;
    private String rawPath;
    private String rawQuery;
    private String scheme;
    private UserinfoBuilder user;

    public URLFluentImpl(){
    }
    public URLFluentImpl(URL instance){
            this.withForceQuery(instance.getForceQuery()); 
            this.withFragment(instance.getFragment()); 
            this.withHost(instance.getHost()); 
            this.withOpaque(instance.getOpaque()); 
            this.withPath(instance.getPath()); 
            this.withRawPath(instance.getRawPath()); 
            this.withRawQuery(instance.getRawQuery()); 
            this.withScheme(instance.getScheme()); 
            this.withUser(instance.getUser()); 
    }

    public Boolean isForceQuery(){
            return this.forceQuery;
    }

    public A withForceQuery(Boolean forceQuery){
            this.forceQuery=forceQuery; return (A) this;
    }

    public Boolean hasForceQuery(){
            return this.forceQuery != null;
    }

    public A withNewForceQuery(String arg1){
            return (A)withForceQuery(new Boolean(arg1));
    }

    public A withNewForceQuery(boolean arg1){
            return (A)withForceQuery(new Boolean(arg1));
    }

    public String getFragment(){
            return this.fragment;
    }

    public A withFragment(String fragment){
            this.fragment=fragment; return (A) this;
    }

    public Boolean hasFragment(){
            return this.fragment != null;
    }

    public A withNewFragment(String arg1){
            return (A)withFragment(new String(arg1));
    }

    public A withNewFragment(StringBuilder arg1){
            return (A)withFragment(new String(arg1));
    }

    public A withNewFragment(StringBuffer arg1){
            return (A)withFragment(new String(arg1));
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    public String getOpaque(){
            return this.opaque;
    }

    public A withOpaque(String opaque){
            this.opaque=opaque; return (A) this;
    }

    public Boolean hasOpaque(){
            return this.opaque != null;
    }

    public A withNewOpaque(String arg1){
            return (A)withOpaque(new String(arg1));
    }

    public A withNewOpaque(StringBuilder arg1){
            return (A)withOpaque(new String(arg1));
    }

    public A withNewOpaque(StringBuffer arg1){
            return (A)withOpaque(new String(arg1));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public String getRawPath(){
            return this.rawPath;
    }

    public A withRawPath(String rawPath){
            this.rawPath=rawPath; return (A) this;
    }

    public Boolean hasRawPath(){
            return this.rawPath != null;
    }

    public A withNewRawPath(String arg1){
            return (A)withRawPath(new String(arg1));
    }

    public A withNewRawPath(StringBuilder arg1){
            return (A)withRawPath(new String(arg1));
    }

    public A withNewRawPath(StringBuffer arg1){
            return (A)withRawPath(new String(arg1));
    }

    public String getRawQuery(){
            return this.rawQuery;
    }

    public A withRawQuery(String rawQuery){
            this.rawQuery=rawQuery; return (A) this;
    }

    public Boolean hasRawQuery(){
            return this.rawQuery != null;
    }

    public A withNewRawQuery(String arg1){
            return (A)withRawQuery(new String(arg1));
    }

    public A withNewRawQuery(StringBuilder arg1){
            return (A)withRawQuery(new String(arg1));
    }

    public A withNewRawQuery(StringBuffer arg1){
            return (A)withRawQuery(new String(arg1));
    }

    public String getScheme(){
            return this.scheme;
    }

    public A withScheme(String scheme){
            this.scheme=scheme; return (A) this;
    }

    public Boolean hasScheme(){
            return this.scheme != null;
    }

    public A withNewScheme(String arg1){
            return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuilder arg1){
            return (A)withScheme(new String(arg1));
    }

    public A withNewScheme(StringBuffer arg1){
            return (A)withScheme(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Userinfo getUser(){
            return this.user!=null?this.user.build():null;
    }

    public Userinfo buildUser(){
            return this.user!=null?this.user.build():null;
    }

    public A withUser(Userinfo user){
            _visitables.get("user").remove(this.user);
            if (user!=null){ this.user= new UserinfoBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public URLFluent.UserNested<A> withNewUser(){
            return new UserNestedImpl();
    }

    public URLFluent.UserNested<A> withNewUserLike(Userinfo item){
            return new UserNestedImpl(item);
    }

    public URLFluent.UserNested<A> editUser(){
            return withNewUserLike(getUser());
    }

    public URLFluent.UserNested<A> editOrNewUser(){
            return withNewUserLike(getUser() != null ? getUser(): new UserinfoBuilder().build());
    }

    public URLFluent.UserNested<A> editOrNewUserLike(Userinfo item){
            return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            URLFluentImpl that = (URLFluentImpl) o;
            if (forceQuery != null ? !forceQuery.equals(that.forceQuery) :that.forceQuery != null) return false;
            if (fragment != null ? !fragment.equals(that.fragment) :that.fragment != null) return false;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            if (opaque != null ? !opaque.equals(that.opaque) :that.opaque != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (rawPath != null ? !rawPath.equals(that.rawPath) :that.rawPath != null) return false;
            if (rawQuery != null ? !rawQuery.equals(that.rawQuery) :that.rawQuery != null) return false;
            if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class UserNestedImpl<N> extends UserinfoFluentImpl<URLFluent.UserNested<N>> implements URLFluent.UserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserinfoBuilder builder;
    
            UserNestedImpl(Userinfo item){
                    this.builder = new UserinfoBuilder(this, item);
            }
            UserNestedImpl(){
                    this.builder = new UserinfoBuilder(this);
            }
    
    public N and(){
            return (N) URLFluentImpl.this.withUser(builder.build());
    }
    public N endUser(){
            return and();
    }

}


}
