package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ResourceListFluent<A extends ResourceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Resource item);
    public A setToItems(int index,Resource item);
    public A addToItems(Resource... items);
    public A addAllToItems(Collection<Resource> items);
    public A removeFromItems(Resource... items);
    public A removeAllFromItems(Collection<Resource> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ResourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<Resource> getItems();
    public List<Resource> buildItems();
    public Resource buildItem(int index);
    public Resource buildFirstItem();
    public Resource buildLastItem();
    public Resource buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ResourceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ResourceBuilder> predicate);
    public A withItems(List<Resource> items);
    public A withItems(Resource... items);
    public Boolean hasItems();
    public ResourceListFluent.ItemsNested<A> addNewItem();
    public ResourceListFluent.ItemsNested<A> addNewItemLike(Resource item);
    public ResourceListFluent.ItemsNested<A> setNewItemLike(int index,Resource item);
    public ResourceListFluent.ItemsNested<A> editItem(int index);
    public ResourceListFluent.ItemsNested<A> editFirstItem();
    public ResourceListFluent.ItemsNested<A> editLastItem();
    public ResourceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ResourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceFluent<ResourceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
