package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelBranchBuilder extends ParallelBranchFluentImpl<ParallelBranchBuilder> implements VisitableBuilder<ParallelBranch,ParallelBranchBuilder>{

    ParallelBranchFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelBranchBuilder(){
            this(true);
    }
    public ParallelBranchBuilder(Boolean validationEnabled){
            this(new ParallelBranch(), validationEnabled);
    }
    public ParallelBranchBuilder(ParallelBranchFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelBranchBuilder(ParallelBranchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelBranch(), validationEnabled);
    }
    public ParallelBranchBuilder(ParallelBranchFluent<?> fluent,ParallelBranch instance){
            this(fluent, instance, true);
    }
    public ParallelBranchBuilder(ParallelBranchFluent<?> fluent,ParallelBranch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFilter(instance.getFilter()); 
            fluent.withReply(instance.getReply()); 
            fluent.withSubscriber(instance.getSubscriber()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelBranchBuilder(ParallelBranch instance){
            this(instance,true);
    }
    public ParallelBranchBuilder(ParallelBranch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFilter(instance.getFilter()); 
            this.withReply(instance.getReply()); 
            this.withSubscriber(instance.getSubscriber()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelBranch build(){
            ParallelBranch buildable = new ParallelBranch(fluent.getFilter(),fluent.getReply(),fluent.getSubscriber());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelBranchBuilder that = (ParallelBranchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
