package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ApiServerSourceListBuilder extends ApiServerSourceListFluentImpl<ApiServerSourceListBuilder> implements VisitableBuilder<ApiServerSourceList,ApiServerSourceListBuilder>{

    ApiServerSourceListFluent<?> fluent;
    Boolean validationEnabled;

    public ApiServerSourceListBuilder(){
            this(true);
    }
    public ApiServerSourceListBuilder(Boolean validationEnabled){
            this(new ApiServerSourceList(), validationEnabled);
    }
    public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent){
            this(fluent, true);
    }
    public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiServerSourceList(), validationEnabled);
    }
    public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent,ApiServerSourceList instance){
            this(fluent, instance, true);
    }
    public ApiServerSourceListBuilder(ApiServerSourceListFluent<?> fluent,ApiServerSourceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiServerSourceListBuilder(ApiServerSourceList instance){
            this(instance,true);
    }
    public ApiServerSourceListBuilder(ApiServerSourceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ApiServerSourceList build(){
            ApiServerSourceList buildable = new ApiServerSourceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiServerSourceListBuilder that = (ApiServerSourceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
