package io.fabric8.knative.legacysources.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class ContainerSourceFluentImpl<A extends ContainerSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerSourceFluent<A>{

    private String apiVersion;
    private DeprecatedBuilder deprecated;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ContainerSourceSpecBuilder spec;
    private ContainerSourceStatusBuilder status;

    public ContainerSourceFluentImpl(){
    }
    public ContainerSourceFluentImpl(ContainerSource instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withDeprecated(instance.getDeprecated()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDeprecated instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Deprecated getDeprecated(){
            return this.deprecated!=null?this.deprecated.build():null;
    }

    public Deprecated buildDeprecated(){
            return this.deprecated!=null?this.deprecated.build():null;
    }

    public A withDeprecated(Deprecated deprecated){
            _visitables.get("deprecated").remove(this.deprecated);
            if (deprecated!=null){ this.deprecated= new DeprecatedBuilder(deprecated); _visitables.get("deprecated").add(this.deprecated);} return (A) this;
    }

    public Boolean hasDeprecated(){
            return this.deprecated != null;
    }

    public ContainerSourceFluent.DeprecatedNested<A> withNewDeprecated(){
            return new DeprecatedNestedImpl();
    }

    public ContainerSourceFluent.DeprecatedNested<A> withNewDeprecatedLike(Deprecated item){
            return new DeprecatedNestedImpl(item);
    }

    public ContainerSourceFluent.DeprecatedNested<A> editDeprecated(){
            return withNewDeprecatedLike(getDeprecated());
    }

    public ContainerSourceFluent.DeprecatedNested<A> editOrNewDeprecated(){
            return withNewDeprecatedLike(getDeprecated() != null ? getDeprecated(): new DeprecatedBuilder().build());
    }

    public ContainerSourceFluent.DeprecatedNested<A> editOrNewDeprecatedLike(Deprecated item){
            return withNewDeprecatedLike(getDeprecated() != null ? getDeprecated(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ContainerSourceFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ContainerSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ContainerSourceFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ContainerSourceFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ContainerSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ContainerSourceSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ContainerSourceSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ContainerSourceSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new ContainerSourceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public ContainerSourceFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ContainerSourceFluent.SpecNested<A> withNewSpecLike(ContainerSourceSpec item){
            return new SpecNestedImpl(item);
    }

    public ContainerSourceFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ContainerSourceFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ContainerSourceSpecBuilder().build());
    }

    public ContainerSourceFluent.SpecNested<A> editOrNewSpecLike(ContainerSourceSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ContainerSourceStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public ContainerSourceStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(ContainerSourceStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new ContainerSourceStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public ContainerSourceFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public ContainerSourceFluent.StatusNested<A> withNewStatusLike(ContainerSourceStatus item){
            return new StatusNestedImpl(item);
    }

    public ContainerSourceFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public ContainerSourceFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new ContainerSourceStatusBuilder().build());
    }

    public ContainerSourceFluent.StatusNested<A> editOrNewStatusLike(ContainerSourceStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ContainerSourceFluentImpl that = (ContainerSourceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (deprecated != null ? !deprecated.equals(that.deprecated) :that.deprecated != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class DeprecatedNestedImpl<N> extends DeprecatedFluentImpl<ContainerSourceFluent.DeprecatedNested<N>> implements ContainerSourceFluent.DeprecatedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeprecatedBuilder builder;
    
            DeprecatedNestedImpl(Deprecated item){
                    this.builder = new DeprecatedBuilder(this, item);
            }
            DeprecatedNestedImpl(){
                    this.builder = new DeprecatedBuilder(this);
            }
    
    public N and(){
            return (N) ContainerSourceFluentImpl.this.withDeprecated(builder.build());
    }
    public N endDeprecated(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ContainerSourceFluent.MetadataNested<N>> implements ContainerSourceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ContainerSourceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ContainerSourceSpecFluentImpl<ContainerSourceFluent.SpecNested<N>> implements ContainerSourceFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerSourceSpecBuilder builder;
    
            SpecNestedImpl(ContainerSourceSpec item){
                    this.builder = new ContainerSourceSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ContainerSourceSpecBuilder(this);
            }
    
    public N and(){
            return (N) ContainerSourceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends ContainerSourceStatusFluentImpl<ContainerSourceFluent.StatusNested<N>> implements ContainerSourceFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerSourceStatusBuilder builder;
    
            StatusNestedImpl(ContainerSourceStatus item){
                    this.builder = new ContainerSourceStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new ContainerSourceStatusBuilder(this);
            }
    
    public N and(){
            return (N) ContainerSourceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
