package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.knative.duck.v1beta1.Destination;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.duck.v1beta1.DestinationFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.knative.duck.v1beta1.DestinationBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerSourceSpecFluent<A extends ContainerSourceSpecFluent<A>> extends Fluent<A>{


    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingArg(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(String arg1);
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(StringBuffer arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(io.fabric8.kubernetes.api.builder.Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.duck.v1beta1.Destination getSink();
    public io.fabric8.knative.duck.v1beta1.Destination buildSink();
    public A withSink(io.fabric8.knative.duck.v1beta1.Destination sink);
    public Boolean hasSink();
    public ContainerSourceSpecFluent.V1beta1SinkNested<A> withNewV1beta1Sink();
    public ContainerSourceSpecFluent.V1beta1SinkNested<A> withNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item);
    public ContainerSourceSpecFluent.V1beta1SinkNested<A> editV1beta1Sink();
    public ContainerSourceSpecFluent.V1beta1SinkNested<A> editOrNewSink();
    public ContainerSourceSpecFluent.V1beta1SinkNested<A> editOrNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item);
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();

    public interface V1beta1SinkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.duck.v1beta1.DestinationFluent<ContainerSourceSpecFluent.V1beta1SinkNested<N>>{

        
    public N and();    public N endV1beta1Sink();
}


}
