package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobLimitsSpecBuilder extends CronJobLimitsSpecFluentImpl<CronJobLimitsSpecBuilder> implements VisitableBuilder<CronJobLimitsSpec,CronJobLimitsSpecBuilder>{

    CronJobLimitsSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobLimitsSpecBuilder(){
            this(true);
    }
    public CronJobLimitsSpecBuilder(Boolean validationEnabled){
            this(new CronJobLimitsSpec(), validationEnabled);
    }
    public CronJobLimitsSpecBuilder(CronJobLimitsSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CronJobLimitsSpecBuilder(CronJobLimitsSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CronJobLimitsSpec(), validationEnabled);
    }
    public CronJobLimitsSpecBuilder(CronJobLimitsSpecFluent<?> fluent,CronJobLimitsSpec instance){
            this(fluent, instance, true);
    }
    public CronJobLimitsSpecBuilder(CronJobLimitsSpecFluent<?> fluent,CronJobLimitsSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCpu(instance.getCpu()); 
            fluent.withMemory(instance.getMemory()); 
            this.validationEnabled = validationEnabled; 
    }
    public CronJobLimitsSpecBuilder(CronJobLimitsSpec instance){
            this(instance,true);
    }
    public CronJobLimitsSpecBuilder(CronJobLimitsSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCpu(instance.getCpu()); 
            this.withMemory(instance.getMemory()); 
            this.validationEnabled = validationEnabled; 
    }

    public CronJobLimitsSpec build(){
            CronJobLimitsSpec buildable = new CronJobLimitsSpec(fluent.getCpu(),fluent.getMemory());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CronJobLimitsSpecBuilder that = (CronJobLimitsSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
