package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobResourceSpecBuilder extends CronJobResourceSpecFluentImpl<CronJobResourceSpecBuilder> implements VisitableBuilder<CronJobResourceSpec,CronJobResourceSpecBuilder>{

    CronJobResourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobResourceSpecBuilder(){
            this(true);
    }
    public CronJobResourceSpecBuilder(Boolean validationEnabled){
            this(new CronJobResourceSpec(), validationEnabled);
    }
    public CronJobResourceSpecBuilder(CronJobResourceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CronJobResourceSpecBuilder(CronJobResourceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CronJobResourceSpec(), validationEnabled);
    }
    public CronJobResourceSpecBuilder(CronJobResourceSpecFluent<?> fluent,CronJobResourceSpec instance){
            this(fluent, instance, true);
    }
    public CronJobResourceSpecBuilder(CronJobResourceSpecFluent<?> fluent,CronJobResourceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLimits(instance.getLimits()); 
            fluent.withRequests(instance.getRequests()); 
            this.validationEnabled = validationEnabled; 
    }
    public CronJobResourceSpecBuilder(CronJobResourceSpec instance){
            this(instance,true);
    }
    public CronJobResourceSpecBuilder(CronJobResourceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLimits(instance.getLimits()); 
            this.withRequests(instance.getRequests()); 
            this.validationEnabled = validationEnabled; 
    }

    public CronJobResourceSpec build(){
            CronJobResourceSpec buildable = new CronJobResourceSpec(fluent.getLimits(),fluent.getRequests());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CronJobResourceSpecBuilder that = (CronJobResourceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
