package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ServiceSpecFluent<A extends io.fabric8.knative.serving.v1alpha1.ServiceSpecFluent<A>> extends Fluent<A>{


    public A addToBuild(String key,Object value);
    public A addToBuild(Map<String,Object> map);
    public A removeFromBuild(String key);
    public A removeFromBuild(Map<String,Object> map);
    public Map<String,Object> getBuild();
    public A withBuild(Map<String,Object> build);
    public Boolean hasBuild();
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    
/**
 * This method has been deprecated, please use method buildManual instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ManualType getManual();
    public ManualType buildManual();
    public A withManual(ManualType manual);
    public Boolean hasManual();
    public ServiceSpecFluent.ManualNested<A> withNewManual();
    public ServiceSpecFluent.ManualNested<A> withNewManualLike(ManualType item);
    public ServiceSpecFluent.ManualNested<A> editManual();
    public ServiceSpecFluent.ManualNested<A> editOrNewManual();
    public ServiceSpecFluent.ManualNested<A> editOrNewManualLike(ManualType item);
    
/**
 * This method has been deprecated, please use method buildPinned instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public PinnedType getPinned();
    public PinnedType buildPinned();
    public A withPinned(PinnedType pinned);
    public Boolean hasPinned();
    public ServiceSpecFluent.PinnedNested<A> withNewPinned();
    public ServiceSpecFluent.PinnedNested<A> withNewPinnedLike(PinnedType item);
    public ServiceSpecFluent.PinnedNested<A> editPinned();
    public ServiceSpecFluent.PinnedNested<A> editOrNewPinned();
    public ServiceSpecFluent.PinnedNested<A> editOrNewPinnedLike(PinnedType item);
    
/**
 * This method has been deprecated, please use method buildRelease instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ReleaseType getRelease();
    public ReleaseType buildRelease();
    public A withRelease(ReleaseType release);
    public Boolean hasRelease();
    public ServiceSpecFluent.ReleaseNested<A> withNewRelease();
    public ServiceSpecFluent.ReleaseNested<A> withNewReleaseLike(ReleaseType item);
    public ServiceSpecFluent.ReleaseNested<A> editRelease();
    public ServiceSpecFluent.ReleaseNested<A> editOrNewRelease();
    public ServiceSpecFluent.ReleaseNested<A> editOrNewReleaseLike(ReleaseType item);
    
/**
 * This method has been deprecated, please use method buildRevisionTemplate instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec getRevisionTemplate();
    public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec buildRevisionTemplate();
    public A withRevisionTemplate(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec revisionTemplate);
    public Boolean hasRevisionTemplate();
    public ServiceSpecFluent.RevisionTemplateNested<A> withNewRevisionTemplate();
    public ServiceSpecFluent.RevisionTemplateNested<A> withNewRevisionTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item);
    public ServiceSpecFluent.RevisionTemplateNested<A> editRevisionTemplate();
    public ServiceSpecFluent.RevisionTemplateNested<A> editOrNewRevisionTemplate();
    public ServiceSpecFluent.RevisionTemplateNested<A> editOrNewRevisionTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item);
    
/**
 * This method has been deprecated, please use method buildRunLatest instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public RunLatestType getRunLatest();
    public RunLatestType buildRunLatest();
    public A withRunLatest(RunLatestType runLatest);
    public Boolean hasRunLatest();
    public ServiceSpecFluent.RunLatestNested<A> withNewRunLatest();
    public ServiceSpecFluent.RunLatestNested<A> withNewRunLatestLike(RunLatestType item);
    public ServiceSpecFluent.RunLatestNested<A> editRunLatest();
    public ServiceSpecFluent.RunLatestNested<A> editOrNewRunLatest();
    public ServiceSpecFluent.RunLatestNested<A> editOrNewRunLatestLike(RunLatestType item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec getTemplate();
    public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec buildTemplate();
    public A withTemplate(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec template);
    public Boolean hasTemplate();
    public ServiceSpecFluent.TemplateNested<A> withNewTemplate();
    public ServiceSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item);
    public ServiceSpecFluent.TemplateNested<A> editTemplate();
    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplate();
    public ServiceSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item);
    public A addToTraffic(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item);
    public A setToTraffic(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item);
    public A addToTraffic(io.fabric8.knative.serving.v1alpha1.TrafficTarget... items);
    public A addAllToTraffic(Collection<io.fabric8.knative.serving.v1alpha1.TrafficTarget> items);
    public A removeFromTraffic(io.fabric8.knative.serving.v1alpha1.TrafficTarget... items);
    public A removeAllFromTraffic(Collection<io.fabric8.knative.serving.v1alpha1.TrafficTarget> items);
    public A removeMatchingFromTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<io.fabric8.knative.serving.v1alpha1.TrafficTarget> getTraffic();
    public List<io.fabric8.knative.serving.v1alpha1.TrafficTarget> buildTraffic();
    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildTraffic(int index);
    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildFirstTraffic();
    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildLastTraffic();
    public io.fabric8.knative.serving.v1alpha1.TrafficTarget buildMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate);
    public Boolean hasMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate);
    public A withTraffic(List<io.fabric8.knative.serving.v1alpha1.TrafficTarget> traffic);
    public A withTraffic(io.fabric8.knative.serving.v1alpha1.TrafficTarget... traffic);
    public Boolean hasTraffic();
    public ServiceSpecFluent.TrafficNested<A> addNewTraffic();
    public ServiceSpecFluent.TrafficNested<A> addNewTrafficLike(io.fabric8.knative.serving.v1alpha1.TrafficTarget item);
    public ServiceSpecFluent.TrafficNested<A> setNewTrafficLike(int index,io.fabric8.knative.serving.v1alpha1.TrafficTarget item);
    public ServiceSpecFluent.TrafficNested<A> editTraffic(int index);
    public ServiceSpecFluent.TrafficNested<A> editFirstTraffic();
    public ServiceSpecFluent.TrafficNested<A> editLastTraffic();
    public ServiceSpecFluent.TrafficNested<A> editMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.serving.v1alpha1.TrafficTargetBuilder> predicate);

    public interface ManualNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ManualTypeFluent<ServiceSpecFluent.ManualNested<N>>{

        
    public N and();    public N endManual();
}
    public interface PinnedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PinnedTypeFluent<ServiceSpecFluent.PinnedNested<N>>{

        
    public N and();    public N endPinned();
}
    public interface ReleaseNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReleaseTypeFluent<ServiceSpecFluent.ReleaseNested<N>>{

        
    public N and();    public N endRelease();
}
    public interface RevisionTemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecFluent<ServiceSpecFluent.RevisionTemplateNested<N>>{

        
    public N and();    public N endRevisionTemplate();
}
    public interface RunLatestNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RunLatestTypeFluent<ServiceSpecFluent.RunLatestNested<N>>{

        
    public N and();    public N endRunLatest();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecFluent<ServiceSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}
    public interface TrafficNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.knative.serving.v1alpha1.TrafficTargetFluent<ServiceSpecFluent.TrafficNested<N>>{

        
    public N and();    public N endTraffic();
}


}
