package io.fabric8.knative.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DestinationBuilder extends DestinationFluentImpl<DestinationBuilder> implements VisitableBuilder<Destination,DestinationBuilder>{

    DestinationFluent<?> fluent;
    Boolean validationEnabled;

    public DestinationBuilder(){
            this(true);
    }
    public DestinationBuilder(Boolean validationEnabled){
            this(new Destination(), validationEnabled);
    }
    public DestinationBuilder(DestinationFluent<?> fluent){
            this(fluent, true);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Destination(), validationEnabled);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Destination instance){
            this(fluent, instance, true);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Destination instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRef(instance.getRef()); 
            fluent.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationBuilder(Destination instance){
            this(instance,true);
    }
    public DestinationBuilder(Destination instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRef(instance.getRef()); 
            this.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public Destination build(){
            Destination buildable = new Destination(fluent.getRef(),fluent.getUri());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationBuilder that = (DestinationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
