package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RunLatestTypeBuilder extends RunLatestTypeFluentImpl<RunLatestTypeBuilder> implements VisitableBuilder<RunLatestType,RunLatestTypeBuilder>{

    RunLatestTypeFluent<?> fluent;
    Boolean validationEnabled;

    public RunLatestTypeBuilder(){
            this(true);
    }
    public RunLatestTypeBuilder(Boolean validationEnabled){
            this(new RunLatestType(), validationEnabled);
    }
    public RunLatestTypeBuilder(RunLatestTypeFluent<?> fluent){
            this(fluent, true);
    }
    public RunLatestTypeBuilder(RunLatestTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RunLatestType(), validationEnabled);
    }
    public RunLatestTypeBuilder(RunLatestTypeFluent<?> fluent,RunLatestType instance){
            this(fluent, instance, true);
    }
    public RunLatestTypeBuilder(RunLatestTypeFluent<?> fluent,RunLatestType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfiguration(instance.getConfiguration()); 
            this.validationEnabled = validationEnabled; 
    }
    public RunLatestTypeBuilder(RunLatestType instance){
            this(instance,true);
    }
    public RunLatestTypeBuilder(RunLatestType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfiguration(instance.getConfiguration()); 
            this.validationEnabled = validationEnabled; 
    }

    public RunLatestType build(){
            RunLatestType buildable = new RunLatestType(fluent.getConfiguration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RunLatestTypeBuilder that = (RunLatestTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
