package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SubscribableStatusFluentImpl<A extends io.fabric8.knative.duck.v1alpha1.SubscribableStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.duck.v1alpha1.SubscribableStatusFluent<A>{

    private List<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder> subscribers;

    public SubscribableStatusFluentImpl(){
    }
    public SubscribableStatusFluentImpl(io.fabric8.knative.duck.v1alpha1.SubscribableStatus instance){
            this.withSubscribers(instance.getSubscribers()); 
    }

    public A addToSubscribers(int index,io.fabric8.knative.duck.v1alpha1.SubscriberStatus item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder>();}
            io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,io.fabric8.knative.duck.v1alpha1.SubscriberStatus item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder>();}
            io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
            if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
             return (A)this;
    }

    public A addToSubscribers(io.fabric8.knative.duck.v1alpha1.SubscriberStatus... items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder>();}
            for (io.fabric8.knative.duck.v1alpha1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<io.fabric8.knative.duck.v1alpha1.SubscriberStatus> items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder>();}
            for (io.fabric8.knative.duck.v1alpha1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(io.fabric8.knative.duck.v1alpha1.SubscriberStatus... items){
            for (io.fabric8.knative.duck.v1alpha1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<io.fabric8.knative.duck.v1alpha1.SubscriberStatus> items){
            for (io.fabric8.knative.duck.v1alpha1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder> predicate){
            if (subscribers == null) return (A) this;
            final Iterator<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder> each = subscribers.iterator();
            final List visitables = _visitables.get("subscribers");
            while (each.hasNext()) {
              io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<io.fabric8.knative.duck.v1alpha1.SubscriberStatus> getSubscribers(){
            return build(subscribers);
    }

    public List<io.fabric8.knative.duck.v1alpha1.SubscriberStatus> buildSubscribers(){
            return build(subscribers);
    }

    public io.fabric8.knative.duck.v1alpha1.SubscriberStatus buildSubscriber(int index){
            return this.subscribers.get(index).build();
    }

    public io.fabric8.knative.duck.v1alpha1.SubscriberStatus buildFirstSubscriber(){
            return this.subscribers.get(0).build();
    }

    public io.fabric8.knative.duck.v1alpha1.SubscriberStatus buildLastSubscriber(){
            return this.subscribers.get(subscribers.size() - 1).build();
    }

    public io.fabric8.knative.duck.v1alpha1.SubscriberStatus buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder> predicate){
            for (io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder item: subscribers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder> predicate){
            for (io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder item: subscribers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubscribers(List<io.fabric8.knative.duck.v1alpha1.SubscriberStatus> subscribers){
            if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
            if (subscribers != null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder>(); for (io.fabric8.knative.duck.v1alpha1.SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(io.fabric8.knative.duck.v1alpha1.SubscriberStatus... subscribers){
            if (this.subscribers != null) {this.subscribers.clear();}
            if (subscribers != null) {for (io.fabric8.knative.duck.v1alpha1.SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers(){
            return subscribers != null && !subscribers.isEmpty();
    }

    public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid){
            return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
    }

    public SubscribableStatusFluent.SubscribersNested<A> addNewSubscriber(){
            return new SubscribersNestedImpl();
    }

    public SubscribableStatusFluent.SubscribersNested<A> addNewSubscriberLike(io.fabric8.knative.duck.v1alpha1.SubscriberStatus item){
            return new SubscribersNestedImpl(-1, item);
    }

    public SubscribableStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index,io.fabric8.knative.duck.v1alpha1.SubscriberStatus item){
            return new SubscribersNestedImpl(index, item);
    }

    public SubscribableStatusFluent.SubscribersNested<A> editSubscriber(int index){
            if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public SubscribableStatusFluent.SubscribersNested<A> editFirstSubscriber(){
            if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
            return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public SubscribableStatusFluent.SubscribersNested<A> editLastSubscriber(){
            int index = subscribers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public SubscribableStatusFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<subscribers.size();i++) { 
            if (predicate.apply(subscribers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubscribableStatusFluentImpl that = (SubscribableStatusFluentImpl) o;
            if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
            return true;
    }


    public class SubscribersNestedImpl<N> extends io.fabric8.knative.duck.v1alpha1.SubscriberStatusFluentImpl<SubscribableStatusFluent.SubscribersNested<N>> implements SubscribableStatusFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder builder;
        private final int index;
    
            SubscribersNestedImpl(int index,io.fabric8.knative.duck.v1alpha1.SubscriberStatus item){
                    this.index = index;
                    this.builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(this, item);
            }
            SubscribersNestedImpl(){
                    this.index = -1;
                    this.builder = new io.fabric8.knative.duck.v1alpha1.SubscriberStatusBuilder(this);
            }
    
    public N and(){
            return (N) SubscribableStatusFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
