package io.fabric8.knative.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelableStatusBuilder extends io.fabric8.knative.duck.v1beta1.ChannelableStatusFluentImpl<io.fabric8.knative.duck.v1beta1.ChannelableStatusBuilder> implements VisitableBuilder<io.fabric8.knative.duck.v1beta1.ChannelableStatus,io.fabric8.knative.duck.v1beta1.ChannelableStatusBuilder>{

    io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelableStatusBuilder(){
            this(true);
    }
    public ChannelableStatusBuilder(Boolean validationEnabled){
            this(new ChannelableStatus(), validationEnabled);
    }
    public ChannelableStatusBuilder(io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelableStatusBuilder(io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ChannelableStatus(), validationEnabled);
    }
    public ChannelableStatusBuilder(io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<?> fluent,io.fabric8.knative.duck.v1beta1.ChannelableStatus instance){
            this(fluent, instance, true);
    }
    public ChannelableStatusBuilder(io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<?> fluent,io.fabric8.knative.duck.v1beta1.ChannelableStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withDeadLetterChannel(instance.getDeadLetterChannel()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelableStatusBuilder(io.fabric8.knative.duck.v1beta1.ChannelableStatus instance){
            this(instance,true);
    }
    public ChannelableStatusBuilder(io.fabric8.knative.duck.v1beta1.ChannelableStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.duck.v1beta1.ChannelableStatus build(){
            ChannelableStatus buildable = new ChannelableStatus(fluent.getAddress(),fluent.getConditions(),fluent.getDeadLetterChannel(),fluent.getObservedGeneration(),fluent.getSubscribers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelableStatusBuilder that = (ChannelableStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
