package io.fabric8.knative.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableSpecBuilder extends SubscribableSpecFluentImpl<SubscribableSpecBuilder> implements VisitableBuilder<SubscribableSpec,SubscribableSpecBuilder>{

    SubscribableSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableSpecBuilder(){
            this(true);
    }
    public SubscribableSpecBuilder(Boolean validationEnabled){
            this(new SubscribableSpec(), validationEnabled);
    }
    public SubscribableSpecBuilder(SubscribableSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableSpecBuilder(SubscribableSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableSpec(), validationEnabled);
    }
    public SubscribableSpecBuilder(SubscribableSpecFluent<?> fluent,SubscribableSpec instance){
            this(fluent, instance, true);
    }
    public SubscribableSpecBuilder(SubscribableSpecFluent<?> fluent,SubscribableSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableSpecBuilder(SubscribableSpec instance){
            this(instance,true);
    }
    public SubscribableSpecBuilder(SubscribableSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscribableSpec build(){
            SubscribableSpec buildable = new SubscribableSpec(fluent.getSubscribers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableSpecBuilder that = (SubscribableSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
