package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventTypeStatusBuilder extends EventTypeStatusFluentImpl<EventTypeStatusBuilder> implements VisitableBuilder<EventTypeStatus,EventTypeStatusBuilder>{

    EventTypeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public EventTypeStatusBuilder(){
            this(true);
    }
    public EventTypeStatusBuilder(Boolean validationEnabled){
            this(new EventTypeStatus(), validationEnabled);
    }
    public EventTypeStatusBuilder(EventTypeStatusFluent<?> fluent){
            this(fluent, true);
    }
    public EventTypeStatusBuilder(EventTypeStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EventTypeStatus(), validationEnabled);
    }
    public EventTypeStatusBuilder(EventTypeStatusFluent<?> fluent,EventTypeStatus instance){
            this(fluent, instance, true);
    }
    public EventTypeStatusBuilder(EventTypeStatusFluent<?> fluent,EventTypeStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public EventTypeStatusBuilder(EventTypeStatus instance){
            this(instance,true);
    }
    public EventTypeStatusBuilder(EventTypeStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }

    public EventTypeStatus build(){
            EventTypeStatus buildable = new EventTypeStatus(fluent.getConditions(),fluent.getObservedGeneration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EventTypeStatusBuilder that = (EventTypeStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
