package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.knative.duck.v1beta1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import io.fabric8.knative.duck.v1beta1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.duck.v1beta1.DestinationFluentImpl;

public class ApiServerSourceSpecFluentImpl<A extends ApiServerSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ApiServerSourceSpecFluent<A>{

    private String mode;
    private List<ApiServerResourceBuilder> resources;
    private String serviceAccountName;
    private io.fabric8.knative.duck.v1beta1.DestinationBuilder sink;

    public ApiServerSourceSpecFluentImpl(){
    }
    public ApiServerSourceSpecFluentImpl(ApiServerSourceSpec instance){
            this.withMode(instance.getMode()); 
            this.withResources(instance.getResources()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withSink(instance.getSink()); 
    }

    public String getMode(){
            return this.mode;
    }

    public A withMode(String mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode != null;
    }

    public A withNewMode(String arg1){
            return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1){
            return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1){
            return (A)withMode(new String(arg1));
    }

    public A addToResources(int index,ApiServerResource item){
            if (this.resources == null) {this.resources = new ArrayList<ApiServerResourceBuilder>();}
            ApiServerResourceBuilder builder = new ApiServerResourceBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,ApiServerResource item){
            if (this.resources == null) {this.resources = new ArrayList<ApiServerResourceBuilder>();}
            ApiServerResourceBuilder builder = new ApiServerResourceBuilder(item);
            if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
            if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
             return (A)this;
    }

    public A addToResources(ApiServerResource... items){
            if (this.resources == null) {this.resources = new ArrayList<ApiServerResourceBuilder>();}
            for (ApiServerResource item : items) {ApiServerResourceBuilder builder = new ApiServerResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<ApiServerResource> items){
            if (this.resources == null) {this.resources = new ArrayList<ApiServerResourceBuilder>();}
            for (ApiServerResource item : items) {ApiServerResourceBuilder builder = new ApiServerResourceBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(ApiServerResource... items){
            for (ApiServerResource item : items) {ApiServerResourceBuilder builder = new ApiServerResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<ApiServerResource> items){
            for (ApiServerResource item : items) {ApiServerResourceBuilder builder = new ApiServerResourceBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResources(io.fabric8.kubernetes.api.builder.Predicate<ApiServerResourceBuilder> predicate){
            if (resources == null) return (A) this;
            final Iterator<ApiServerResourceBuilder> each = resources.iterator();
            final List visitables = _visitables.get("resources");
            while (each.hasNext()) {
              ApiServerResourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<ApiServerResource> getResources(){
            return build(resources);
    }

    public List<ApiServerResource> buildResources(){
            return build(resources);
    }

    public ApiServerResource buildResource(int index){
            return this.resources.get(index).build();
    }

    public ApiServerResource buildFirstResource(){
            return this.resources.get(0).build();
    }

    public ApiServerResource buildLastResource(){
            return this.resources.get(resources.size() - 1).build();
    }

    public ApiServerResource buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<ApiServerResourceBuilder> predicate){
            for (ApiServerResourceBuilder item: resources) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<ApiServerResourceBuilder> predicate){
            for (ApiServerResourceBuilder item: resources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResources(List<ApiServerResource> resources){
            if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
            if (resources != null) {this.resources = new ArrayList<ApiServerResourceBuilder>(); for (ApiServerResource item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(ApiServerResource... resources){
            if (this.resources != null) {this.resources.clear();}
            if (resources != null) {for (ApiServerResource item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources(){
            return resources != null && !resources.isEmpty();
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> addNewResource(){
            return new ResourcesNestedImpl();
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> addNewResourceLike(ApiServerResource item){
            return new ResourcesNestedImpl(-1, item);
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> setNewResourceLike(int index,ApiServerResource item){
            return new ResourcesNestedImpl(index, item);
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editResource(int index){
            if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
            return setNewResourceLike(index, buildResource(index));
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editFirstResource(){
            if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
            return setNewResourceLike(0, buildResource(0));
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editLastResource(){
            int index = resources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
            return setNewResourceLike(index, buildResource(index));
    }

    public ApiServerSourceSpecFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<ApiServerResourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<resources.size();i++) { 
            if (predicate.apply(resources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
            return setNewResourceLike(index, buildResource(index));
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.duck.v1beta1.Destination getSink(){
            return this.sink!=null?this.sink.build():null;
    }

    public io.fabric8.knative.duck.v1beta1.Destination buildSink(){
            return this.sink!=null?this.sink.build():null;
    }

    public A withSink(io.fabric8.knative.duck.v1beta1.Destination sink){
            _visitables.get("sink").remove(this.sink);
            if (sink!=null){ this.sink= new io.fabric8.knative.duck.v1beta1.DestinationBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink(){
            return this.sink != null;
    }

    public ApiServerSourceSpecFluent.V1beta1SinkNested<A> withNewV1beta1Sink(){
            return new V1beta1SinkNestedImpl();
    }

    public ApiServerSourceSpecFluent.V1beta1SinkNested<A> withNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item){
            return new V1beta1SinkNestedImpl(item);
    }

    public ApiServerSourceSpecFluent.V1beta1SinkNested<A> editV1beta1Sink(){
            return withNewSinkLike(getSink());
    }

    public ApiServerSourceSpecFluent.V1beta1SinkNested<A> editOrNewSink(){
            return withNewSinkLike(getSink() != null ? getSink(): new io.fabric8.knative.duck.v1beta1.DestinationBuilder().build());
    }

    public ApiServerSourceSpecFluent.V1beta1SinkNested<A> editOrNewSinkLike(io.fabric8.knative.duck.v1beta1.Destination item){
            return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ApiServerSourceSpecFluentImpl that = (ApiServerSourceSpecFluentImpl) o;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
            return true;
    }


    public class ResourcesNestedImpl<N> extends ApiServerResourceFluentImpl<ApiServerSourceSpecFluent.ResourcesNested<N>> implements ApiServerSourceSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ApiServerResourceBuilder builder;
        private final int index;
    
            ResourcesNestedImpl(int index,ApiServerResource item){
                    this.index = index;
                    this.builder = new ApiServerResourceBuilder(this, item);
            }
            ResourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new ApiServerResourceBuilder(this);
            }
    
    public N and(){
            return (N) ApiServerSourceSpecFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource(){
            return and();
    }

}
    public class V1beta1SinkNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.DestinationFluentImpl<ApiServerSourceSpecFluent.V1beta1SinkNested<N>> implements ApiServerSourceSpecFluent.V1beta1SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.DestinationBuilder builder;
    
            V1beta1SinkNestedImpl(io.fabric8.knative.duck.v1beta1.Destination item){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DestinationBuilder(this, item);
            }
            V1beta1SinkNestedImpl(){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DestinationBuilder(this);
            }
    
    public N and(){
            return (N) ApiServerSourceSpecFluentImpl.this.withSink(builder.build());
    }
    public N endV1beta1Sink(){
            return and();
    }

}


}
