package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobSourceSpecBuilder extends CronJobSourceSpecFluentImpl<CronJobSourceSpecBuilder> implements VisitableBuilder<CronJobSourceSpec,CronJobSourceSpecBuilder>{

    CronJobSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobSourceSpecBuilder(){
            this(true);
    }
    public CronJobSourceSpecBuilder(Boolean validationEnabled){
            this(new CronJobSourceSpec(), validationEnabled);
    }
    public CronJobSourceSpecBuilder(CronJobSourceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CronJobSourceSpecBuilder(CronJobSourceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CronJobSourceSpec(), validationEnabled);
    }
    public CronJobSourceSpecBuilder(CronJobSourceSpecFluent<?> fluent,CronJobSourceSpec instance){
            this(fluent, instance, true);
    }
    public CronJobSourceSpecBuilder(CronJobSourceSpecFluent<?> fluent,CronJobSourceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withData(instance.getData()); 
            fluent.withResources(instance.getResources()); 
            fluent.withSchedule(instance.getSchedule()); 
            fluent.withServiceAccountName(instance.getServiceAccountName()); 
            fluent.withSink(instance.getSink()); 
            this.validationEnabled = validationEnabled; 
    }
    public CronJobSourceSpecBuilder(CronJobSourceSpec instance){
            this(instance,true);
    }
    public CronJobSourceSpecBuilder(CronJobSourceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withData(instance.getData()); 
            this.withResources(instance.getResources()); 
            this.withSchedule(instance.getSchedule()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withSink(instance.getSink()); 
            this.validationEnabled = validationEnabled; 
    }

    public CronJobSourceSpec build(){
            CronJobSourceSpec buildable = new CronJobSourceSpec(fluent.getData(),fluent.getResources(),fluent.getSchedule(),fluent.getServiceAccountName(),fluent.getSink());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CronJobSourceSpecBuilder that = (CronJobSourceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
