package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelableListBuilder extends ChannelableListFluentImpl<ChannelableListBuilder> implements VisitableBuilder<ChannelableList,ChannelableListBuilder>{

    ChannelableListFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelableListBuilder(){
            this(true);
    }
    public ChannelableListBuilder(Boolean validationEnabled){
            this(new ChannelableList(), validationEnabled);
    }
    public ChannelableListBuilder(ChannelableListFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelableListBuilder(ChannelableListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ChannelableList(), validationEnabled);
    }
    public ChannelableListBuilder(ChannelableListFluent<?> fluent,ChannelableList instance){
            this(fluent, instance, true);
    }
    public ChannelableListBuilder(ChannelableListFluent<?> fluent,ChannelableList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelableListBuilder(ChannelableList instance){
            this(instance,true);
    }
    public ChannelableListBuilder(ChannelableList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ChannelableList build(){
            ChannelableList buildable = new ChannelableList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelableListBuilder that = (ChannelableListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
