package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableTypeSpecBuilder extends SubscribableTypeSpecFluentImpl<SubscribableTypeSpecBuilder> implements VisitableBuilder<SubscribableTypeSpec,SubscribableTypeSpecBuilder>{

    SubscribableTypeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableTypeSpecBuilder(){
            this(true);
    }
    public SubscribableTypeSpecBuilder(Boolean validationEnabled){
            this(new SubscribableTypeSpec(), validationEnabled);
    }
    public SubscribableTypeSpecBuilder(SubscribableTypeSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableTypeSpecBuilder(SubscribableTypeSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableTypeSpec(), validationEnabled);
    }
    public SubscribableTypeSpecBuilder(SubscribableTypeSpecFluent<?> fluent,SubscribableTypeSpec instance){
            this(fluent, instance, true);
    }
    public SubscribableTypeSpecBuilder(SubscribableTypeSpecFluent<?> fluent,SubscribableTypeSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableTypeSpecBuilder(SubscribableTypeSpec instance){
            this(instance,true);
    }
    public SubscribableTypeSpecBuilder(SubscribableTypeSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscribableTypeSpec build(){
            SubscribableTypeSpec buildable = new SubscribableTypeSpec(fluent.getSubscribable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableTypeSpecBuilder that = (SubscribableTypeSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
