package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelBranchStatusBuilder extends ParallelBranchStatusFluentImpl<ParallelBranchStatusBuilder> implements VisitableBuilder<ParallelBranchStatus,ParallelBranchStatusBuilder>{

    ParallelBranchStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelBranchStatusBuilder(){
            this(true);
    }
    public ParallelBranchStatusBuilder(Boolean validationEnabled){
            this(new ParallelBranchStatus(), validationEnabled);
    }
    public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelBranchStatus(), validationEnabled);
    }
    public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent,ParallelBranchStatus instance){
            this(fluent, instance, true);
    }
    public ParallelBranchStatusBuilder(ParallelBranchStatusFluent<?> fluent,ParallelBranchStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFilterChannelStatus(instance.getFilterChannelStatus()); 
            fluent.withFilterSubscriptionStatus(instance.getFilterSubscriptionStatus()); 
            fluent.withSubscriberSubscriptionStatus(instance.getSubscriberSubscriptionStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelBranchStatusBuilder(ParallelBranchStatus instance){
            this(instance,true);
    }
    public ParallelBranchStatusBuilder(ParallelBranchStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFilterChannelStatus(instance.getFilterChannelStatus()); 
            this.withFilterSubscriptionStatus(instance.getFilterSubscriptionStatus()); 
            this.withSubscriberSubscriptionStatus(instance.getSubscriberSubscriptionStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelBranchStatus build(){
            ParallelBranchStatus buildable = new ParallelBranchStatus(fluent.getFilterChannelStatus(),fluent.getFilterSubscriptionStatus(),fluent.getSubscriberSubscriptionStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelBranchStatusBuilder that = (ParallelBranchStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
