package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelBuilder extends ParallelFluentImpl<ParallelBuilder> implements VisitableBuilder<Parallel,ParallelBuilder>{

    ParallelFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelBuilder(){
            this(true);
    }
    public ParallelBuilder(Boolean validationEnabled){
            this(new Parallel(), validationEnabled);
    }
    public ParallelBuilder(ParallelFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelBuilder(ParallelFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Parallel(), validationEnabled);
    }
    public ParallelBuilder(ParallelFluent<?> fluent,Parallel instance){
            this(fluent, instance, true);
    }
    public ParallelBuilder(ParallelFluent<?> fluent,Parallel instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelBuilder(Parallel instance){
            this(instance,true);
    }
    public ParallelBuilder(Parallel instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public Parallel build(){
            Parallel buildable = new Parallel(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelBuilder that = (ParallelBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
