package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import io.fabric8.knative.v1.ConditionBuilder;
import io.fabric8.knative.v1.ConditionFluentImpl;
import io.fabric8.knative.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class ParallelStatusFluentImpl<A extends ParallelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ParallelStatusFluent<A>{

    private AddressableBuilder address;
    private List<ParallelBranchStatusBuilder> branchStatuses;
    private List<ConditionBuilder> conditions;
    private ParallelChannelStatusBuilder ingressChannelStatus;
    private Long observedGeneration;

    public ParallelStatusFluentImpl(){
    }
    public ParallelStatusFluentImpl(ParallelStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withBranchStatuses(instance.getBranchStatuses()); 
            this.withConditions(instance.getConditions()); 
            this.withIngressChannelStatus(instance.getIngressChannelStatus()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String url){
            return (A)withAddress(new Addressable(url));
    }

    public ParallelStatusFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public ParallelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item){
            return new AddressNestedImpl(item);
    }

    public ParallelStatusFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public ParallelStatusFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public ParallelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToBranchStatuses(int index,ParallelBranchStatus item){
            if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").add(index >= 0 ? index : _visitables.get("branchStatuses").size(), builder);this.branchStatuses.add(index >= 0 ? index : branchStatuses.size(), builder); return (A)this;
    }

    public A setToBranchStatuses(int index,ParallelBranchStatus item){
            if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
            ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("branchStatuses").size()) { _visitables.get("branchStatuses").add(builder); } else { _visitables.get("branchStatuses").set(index, builder);}
            if (index < 0 || index >= branchStatuses.size()) { branchStatuses.add(builder); } else { branchStatuses.set(index, builder);}
             return (A)this;
    }

    public A addToBranchStatuses(ParallelBranchStatus... items){
            if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
            for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").add(builder);this.branchStatuses.add(builder);} return (A)this;
    }

    public A addAllToBranchStatuses(Collection<ParallelBranchStatus> items){
            if (this.branchStatuses == null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>();}
            for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").add(builder);this.branchStatuses.add(builder);} return (A)this;
    }

    public A removeFromBranchStatuses(ParallelBranchStatus... items){
            for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").remove(builder);if (this.branchStatuses != null) {this.branchStatuses.remove(builder);}} return (A)this;
    }

    public A removeAllFromBranchStatuses(Collection<ParallelBranchStatus> items){
            for (ParallelBranchStatus item : items) {ParallelBranchStatusBuilder builder = new ParallelBranchStatusBuilder(item);_visitables.get("branchStatuses").remove(builder);if (this.branchStatuses != null) {this.branchStatuses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBranchStatuses(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchStatusBuilder> predicate){
            if (branchStatuses == null) return (A) this;
            final Iterator<ParallelBranchStatusBuilder> each = branchStatuses.iterator();
            final List visitables = _visitables.get("branchStatuses");
            while (each.hasNext()) {
              ParallelBranchStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBranchStatuses instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<ParallelBranchStatus> getBranchStatuses(){
            return build(branchStatuses);
    }

    public List<ParallelBranchStatus> buildBranchStatuses(){
            return build(branchStatuses);
    }

    public ParallelBranchStatus buildBranchStatus(int index){
            return this.branchStatuses.get(index).build();
    }

    public ParallelBranchStatus buildFirstBranchStatus(){
            return this.branchStatuses.get(0).build();
    }

    public ParallelBranchStatus buildLastBranchStatus(){
            return this.branchStatuses.get(branchStatuses.size() - 1).build();
    }

    public ParallelBranchStatus buildMatchingBranchStatus(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchStatusBuilder> predicate){
            for (ParallelBranchStatusBuilder item: branchStatuses) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBranchStatus(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchStatusBuilder> predicate){
            for (ParallelBranchStatusBuilder item: branchStatuses) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBranchStatuses(List<ParallelBranchStatus> branchStatuses){
            if (this.branchStatuses != null) { _visitables.get("branchStatuses").removeAll(this.branchStatuses);}
            if (branchStatuses != null) {this.branchStatuses = new ArrayList<ParallelBranchStatusBuilder>(); for (ParallelBranchStatus item : branchStatuses){this.addToBranchStatuses(item);}} else { this.branchStatuses = null;} return (A) this;
    }

    public A withBranchStatuses(ParallelBranchStatus... branchStatuses){
            if (this.branchStatuses != null) {this.branchStatuses.clear();}
            if (branchStatuses != null) {for (ParallelBranchStatus item :branchStatuses){ this.addToBranchStatuses(item);}} return (A) this;
    }

    public Boolean hasBranchStatuses(){
            return branchStatuses != null && !branchStatuses.isEmpty();
    }

    public ParallelStatusFluent.BranchStatusesNested<A> addNewBranchStatus(){
            return new BranchStatusesNestedImpl();
    }

    public ParallelStatusFluent.BranchStatusesNested<A> addNewBranchStatusLike(ParallelBranchStatus item){
            return new BranchStatusesNestedImpl(-1, item);
    }

    public ParallelStatusFluent.BranchStatusesNested<A> setNewBranchStatusLike(int index,ParallelBranchStatus item){
            return new BranchStatusesNestedImpl(index, item);
    }

    public ParallelStatusFluent.BranchStatusesNested<A> editBranchStatus(int index){
            if (branchStatuses.size() <= index) throw new RuntimeException("Can't edit branchStatuses. Index exceeds size.");
            return setNewBranchStatusLike(index, buildBranchStatus(index));
    }

    public ParallelStatusFluent.BranchStatusesNested<A> editFirstBranchStatus(){
            if (branchStatuses.size() == 0) throw new RuntimeException("Can't edit first branchStatuses. The list is empty.");
            return setNewBranchStatusLike(0, buildBranchStatus(0));
    }

    public ParallelStatusFluent.BranchStatusesNested<A> editLastBranchStatus(){
            int index = branchStatuses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last branchStatuses. The list is empty.");
            return setNewBranchStatusLike(index, buildBranchStatus(index));
    }

    public ParallelStatusFluent.BranchStatusesNested<A> editMatchingBranchStatus(io.fabric8.kubernetes.api.builder.Predicate<ParallelBranchStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<branchStatuses.size();i++) { 
            if (predicate.apply(branchStatuses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching branchStatuses. No match found.");
            return setNewBranchStatusLike(index, buildBranchStatus(index));
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<ConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              ConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public ParallelStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ParallelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public ParallelStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public ParallelStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ParallelStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public ParallelStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ParallelStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildIngressChannelStatus instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ParallelChannelStatus getIngressChannelStatus(){
            return this.ingressChannelStatus!=null?this.ingressChannelStatus.build():null;
    }

    public ParallelChannelStatus buildIngressChannelStatus(){
            return this.ingressChannelStatus!=null?this.ingressChannelStatus.build():null;
    }

    public A withIngressChannelStatus(ParallelChannelStatus ingressChannelStatus){
            _visitables.get("ingressChannelStatus").remove(this.ingressChannelStatus);
            if (ingressChannelStatus!=null){ this.ingressChannelStatus= new ParallelChannelStatusBuilder(ingressChannelStatus); _visitables.get("ingressChannelStatus").add(this.ingressChannelStatus);} return (A) this;
    }

    public Boolean hasIngressChannelStatus(){
            return this.ingressChannelStatus != null;
    }

    public ParallelStatusFluent.IngressChannelStatusNested<A> withNewIngressChannelStatus(){
            return new IngressChannelStatusNestedImpl();
    }

    public ParallelStatusFluent.IngressChannelStatusNested<A> withNewIngressChannelStatusLike(ParallelChannelStatus item){
            return new IngressChannelStatusNestedImpl(item);
    }

    public ParallelStatusFluent.IngressChannelStatusNested<A> editIngressChannelStatus(){
            return withNewIngressChannelStatusLike(getIngressChannelStatus());
    }

    public ParallelStatusFluent.IngressChannelStatusNested<A> editOrNewIngressChannelStatus(){
            return withNewIngressChannelStatusLike(getIngressChannelStatus() != null ? getIngressChannelStatus(): new ParallelChannelStatusBuilder().build());
    }

    public ParallelStatusFluent.IngressChannelStatusNested<A> editOrNewIngressChannelStatusLike(ParallelChannelStatus item){
            return withNewIngressChannelStatusLike(getIngressChannelStatus() != null ? getIngressChannelStatus(): item);
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ParallelStatusFluentImpl that = (ParallelStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (branchStatuses != null ? !branchStatuses.equals(that.branchStatuses) :that.branchStatuses != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (ingressChannelStatus != null ? !ingressChannelStatus.equals(that.ingressChannelStatus) :that.ingressChannelStatus != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressableFluentImpl<ParallelStatusFluent.AddressNested<N>> implements ParallelStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AddressableBuilder builder;
    
            AddressNestedImpl(Addressable item){
                    this.builder = new AddressableBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressableBuilder(this);
            }
    
    public N and(){
            return (N) ParallelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class BranchStatusesNestedImpl<N> extends ParallelBranchStatusFluentImpl<ParallelStatusFluent.BranchStatusesNested<N>> implements ParallelStatusFluent.BranchStatusesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParallelBranchStatusBuilder builder;
        private final int index;
    
            BranchStatusesNestedImpl(int index,ParallelBranchStatus item){
                    this.index = index;
                    this.builder = new ParallelBranchStatusBuilder(this, item);
            }
            BranchStatusesNestedImpl(){
                    this.index = -1;
                    this.builder = new ParallelBranchStatusBuilder(this);
            }
    
    public N and(){
            return (N) ParallelStatusFluentImpl.this.setToBranchStatuses(index,builder.build());
    }
    public N endBranchStatus(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<ParallelStatusFluent.ConditionsNested<N>> implements ParallelStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) ParallelStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class IngressChannelStatusNestedImpl<N> extends ParallelChannelStatusFluentImpl<ParallelStatusFluent.IngressChannelStatusNested<N>> implements ParallelStatusFluent.IngressChannelStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ParallelChannelStatusBuilder builder;
    
            IngressChannelStatusNestedImpl(ParallelChannelStatus item){
                    this.builder = new ParallelChannelStatusBuilder(this, item);
            }
            IngressChannelStatusNestedImpl(){
                    this.builder = new ParallelChannelStatusBuilder(this);
            }
    
    public N and(){
            return (N) ParallelStatusFluentImpl.this.withIngressChannelStatus(builder.build());
    }
    public N endIngressChannelStatus(){
            return and();
    }

}


}
