package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpec;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.knative.duck.v1.DestinationFluentImpl;

public class SequenceSpecFluentImpl<A extends SequenceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceSpecFluent<A>{

    private ChannelTemplateSpecBuilder channelTemplate;
    private DestinationBuilder reply;
    private List<SequenceStepBuilder> steps;

    public SequenceSpecFluentImpl(){
    }
    public SequenceSpecFluentImpl(SequenceSpec instance){
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withReply(instance.getReply()); 
            this.withSteps(instance.getSteps()); 
    }

    
/**
 * This method has been deprecated, please use method buildChannelTemplate instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public ChannelTemplateSpec getChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public ChannelTemplateSpec buildChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(ChannelTemplateSpec channelTemplate){
            _visitables.get("channelTemplate").remove(this.channelTemplate);
            if (channelTemplate!=null){ this.channelTemplate= new ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public Boolean hasChannelTemplate(){
            return this.channelTemplate != null;
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate(){
            return new ChannelTemplateNestedImpl();
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item){
            return new ChannelTemplateNestedImpl(item);
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> editChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate());
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new ChannelTemplateSpecBuilder().build());
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Destination getReply(){
            return this.reply!=null?this.reply.build():null;
    }

    public Destination buildReply(){
            return this.reply!=null?this.reply.build():null;
    }

    public A withReply(Destination reply){
            _visitables.get("reply").remove(this.reply);
            if (reply!=null){ this.reply= new DestinationBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public Boolean hasReply(){
            return this.reply != null;
    }

    public SequenceSpecFluent.ReplyNested<A> withNewReply(){
            return new ReplyNestedImpl();
    }

    public SequenceSpecFluent.ReplyNested<A> withNewReplyLike(Destination item){
            return new ReplyNestedImpl(item);
    }

    public SequenceSpecFluent.ReplyNested<A> editReply(){
            return withNewReplyLike(getReply());
    }

    public SequenceSpecFluent.ReplyNested<A> editOrNewReply(){
            return withNewReplyLike(getReply() != null ? getReply(): new DestinationBuilder().build());
    }

    public SequenceSpecFluent.ReplyNested<A> editOrNewReplyLike(Destination item){
            return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    public A addToSteps(int index,SequenceStep item){
            if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
            SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(index >= 0 ? index : _visitables.get("steps").size(), builder);this.steps.add(index >= 0 ? index : steps.size(), builder); return (A)this;
    }

    public A setToSteps(int index,SequenceStep item){
            if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
            SequenceStepBuilder builder = new SequenceStepBuilder(item);
            if (index < 0 || index >= _visitables.get("steps").size()) { _visitables.get("steps").add(builder); } else { _visitables.get("steps").set(index, builder);}
            if (index < 0 || index >= steps.size()) { steps.add(builder); } else { steps.set(index, builder);}
             return (A)this;
    }

    public A addToSteps(SequenceStep... items){
            if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
            for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A addAllToSteps(Collection<SequenceStep> items){
            if (this.steps == null) {this.steps = new ArrayList<SequenceStepBuilder>();}
            for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A removeFromSteps(SequenceStep... items){
            for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeAllFromSteps(Collection<SequenceStep> items){
            for (SequenceStep item : items) {SequenceStepBuilder builder = new SequenceStepBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSteps(io.fabric8.kubernetes.api.builder.Predicate<SequenceStepBuilder> predicate){
            if (steps == null) return (A) this;
            final Iterator<SequenceStepBuilder> each = steps.iterator();
            final List visitables = _visitables.get("steps");
            while (each.hasNext()) {
              SequenceStepBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSteps instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<SequenceStep> getSteps(){
            return build(steps);
    }

    public List<SequenceStep> buildSteps(){
            return build(steps);
    }

    public SequenceStep buildStep(int index){
            return this.steps.get(index).build();
    }

    public SequenceStep buildFirstStep(){
            return this.steps.get(0).build();
    }

    public SequenceStep buildLastStep(){
            return this.steps.get(steps.size() - 1).build();
    }

    public SequenceStep buildMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<SequenceStepBuilder> predicate){
            for (SequenceStepBuilder item: steps) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<SequenceStepBuilder> predicate){
            for (SequenceStepBuilder item: steps) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSteps(List<SequenceStep> steps){
            if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
            if (steps != null) {this.steps = new ArrayList<SequenceStepBuilder>(); for (SequenceStep item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
    }

    public A withSteps(SequenceStep... steps){
            if (this.steps != null) {this.steps.clear();}
            if (steps != null) {for (SequenceStep item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public Boolean hasSteps(){
            return steps != null && !steps.isEmpty();
    }

    public SequenceSpecFluent.StepsNested<A> addNewStep(){
            return new StepsNestedImpl();
    }

    public SequenceSpecFluent.StepsNested<A> addNewStepLike(SequenceStep item){
            return new StepsNestedImpl(-1, item);
    }

    public SequenceSpecFluent.StepsNested<A> setNewStepLike(int index,SequenceStep item){
            return new StepsNestedImpl(index, item);
    }

    public SequenceSpecFluent.StepsNested<A> editStep(int index){
            if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
            return setNewStepLike(index, buildStep(index));
    }

    public SequenceSpecFluent.StepsNested<A> editFirstStep(){
            if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
            return setNewStepLike(0, buildStep(0));
    }

    public SequenceSpecFluent.StepsNested<A> editLastStep(){
            int index = steps.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
            return setNewStepLike(index, buildStep(index));
    }

    public SequenceSpecFluent.StepsNested<A> editMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<SequenceStepBuilder> predicate){
            int index = -1;
            for (int i=0;i<steps.size();i++) { 
            if (predicate.apply(steps.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
            return setNewStepLike(index, buildStep(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SequenceSpecFluentImpl that = (SequenceSpecFluentImpl) o;
            if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
            if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
            if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
            return true;
    }


    public class ChannelTemplateNestedImpl<N> extends ChannelTemplateSpecFluentImpl<SequenceSpecFluent.ChannelTemplateNested<N>> implements SequenceSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ChannelTemplateSpecBuilder builder;
    
            ChannelTemplateNestedImpl(ChannelTemplateSpec item){
                    this.builder = new ChannelTemplateSpecBuilder(this, item);
            }
            ChannelTemplateNestedImpl(){
                    this.builder = new ChannelTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) SequenceSpecFluentImpl.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate(){
            return and();
    }

}
    public class ReplyNestedImpl<N> extends DestinationFluentImpl<SequenceSpecFluent.ReplyNested<N>> implements SequenceSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationBuilder builder;
    
            ReplyNestedImpl(Destination item){
                    this.builder = new DestinationBuilder(this, item);
            }
            ReplyNestedImpl(){
                    this.builder = new DestinationBuilder(this);
            }
    
    public N and(){
            return (N) SequenceSpecFluentImpl.this.withReply(builder.build());
    }
    public N endReply(){
            return and();
    }

}
    public class StepsNestedImpl<N> extends SequenceStepFluentImpl<SequenceSpecFluent.StepsNested<N>> implements SequenceSpecFluent.StepsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SequenceStepBuilder builder;
        private final int index;
    
            StepsNestedImpl(int index,SequenceStep item){
                    this.index = index;
                    this.builder = new SequenceStepBuilder(this, item);
            }
            StepsNestedImpl(){
                    this.index = -1;
                    this.builder = new SequenceStepBuilder(this);
            }
    
    public N and(){
            return (N) SequenceSpecFluentImpl.this.setToSteps(index,builder.build());
    }
    public N endStep(){
            return and();
    }

}


}
