package io.fabric8.knative.legacysources.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobRequestsSpecBuilder extends CronJobRequestsSpecFluentImpl<CronJobRequestsSpecBuilder> implements VisitableBuilder<CronJobRequestsSpec,CronJobRequestsSpecBuilder>{

    CronJobRequestsSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobRequestsSpecBuilder(){
            this(true);
    }
    public CronJobRequestsSpecBuilder(Boolean validationEnabled){
            this(new CronJobRequestsSpec(), validationEnabled);
    }
    public CronJobRequestsSpecBuilder(CronJobRequestsSpecFluent<?> fluent){
            this(fluent, true);
    }
    public CronJobRequestsSpecBuilder(CronJobRequestsSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CronJobRequestsSpec(), validationEnabled);
    }
    public CronJobRequestsSpecBuilder(CronJobRequestsSpecFluent<?> fluent,CronJobRequestsSpec instance){
            this(fluent, instance, true);
    }
    public CronJobRequestsSpecBuilder(CronJobRequestsSpecFluent<?> fluent,CronJobRequestsSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCpu(instance.getCpu()); 
            fluent.withMemory(instance.getMemory()); 
            this.validationEnabled = validationEnabled; 
    }
    public CronJobRequestsSpecBuilder(CronJobRequestsSpec instance){
            this(instance,true);
    }
    public CronJobRequestsSpecBuilder(CronJobRequestsSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCpu(instance.getCpu()); 
            this.withMemory(instance.getMemory()); 
            this.validationEnabled = validationEnabled; 
    }

    public CronJobRequestsSpec build(){
            CronJobRequestsSpec buildable = new CronJobRequestsSpec(fluent.getCpu(),fluent.getMemory());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CronJobRequestsSpecBuilder that = (CronJobRequestsSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
