package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ChannelListFluent<A extends ChannelListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Channel item);
    public A setToItems(int index,Channel item);
    public A addToItems(Channel... items);
    public A addAllToItems(Collection<Channel> items);
    public A removeFromItems(Channel... items);
    public A removeAllFromItems(Collection<Channel> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ChannelBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Channel> getItems();
    public List<Channel> buildItems();
    public Channel buildItem(int index);
    public Channel buildFirstItem();
    public Channel buildLastItem();
    public Channel buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ChannelBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ChannelBuilder> predicate);
    public A withItems(List<Channel> items);
    public A withItems(Channel... items);
    public Boolean hasItems();
    public ChannelListFluent.ItemsNested<A> addNewItem();
    public ChannelListFluent.ItemsNested<A> addNewItemLike(Channel item);
    public ChannelListFluent.ItemsNested<A> setNewItemLike(int index,Channel item);
    public ChannelListFluent.ItemsNested<A> editItem(int index);
    public ChannelListFluent.ItemsNested<A> editFirstItem();
    public ChannelListFluent.ItemsNested<A> editLastItem();
    public ChannelListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ChannelBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ChannelFluent<ChannelListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
