package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.kubernetes.api.builder.Editable;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;

public class EditableGitHubSourceSpec extends GitHubSourceSpec implements io.fabric8.kubernetes.api.builder.Editable<GitHubSourceSpecBuilder> {


    
/**
 * No args constructor for use in serialization
 */
public EditableGitHubSourceSpec() { 
        super();
    }


    
/**
 * @param githubAPIURL
 * @param serviceAccountName
 * @param sink
 * @param secretToken
 * @param accessToken
 * @param ceOverrides
 * @param eventTypes
 * @param secure
 * @param ownerAndRepository
 */
public EditableGitHubSourceSpec(SecretValueFromSource accessToken,CloudEventOverrides ceOverrides,List<String> eventTypes,String githubAPIURL,String ownerAndRepository,SecretValueFromSource secretToken,Boolean secure,String serviceAccountName,Destination sink) { 
        super(accessToken, ceOverrides, eventTypes, githubAPIURL, ownerAndRepository, secretToken, secure, serviceAccountName, sink);
    }


    public GitHubSourceSpecBuilder edit() {
        return new GitHubSourceSpecBuilder(this);
    }

}
