package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabBindingBuilder extends GitLabBindingFluentImpl<GitLabBindingBuilder> implements VisitableBuilder<GitLabBinding,GitLabBindingBuilder> {

    GitLabBindingFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabBindingBuilder() { 
        this(true);
    }


    public GitLabBindingBuilder(Boolean validationEnabled) { 
        this(new GitLabBinding(), validationEnabled);
    }


    public GitLabBindingBuilder(GitLabBindingFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitLabBinding(), validationEnabled);
    }


    public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,GitLabBinding instance) { 
        this(fluent, instance, true);
    }


    public GitLabBindingBuilder(GitLabBindingFluent<?> fluent,GitLabBinding instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabBindingBuilder(GitLabBinding instance) { 
        this(instance,true);
    }


    public GitLabBindingBuilder(GitLabBinding instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.EditableGitLabBinding build() {
        EditableGitLabBinding buildable = new EditableGitLabBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabBindingBuilder that = (GitLabBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
