package io.fabric8.knative.messaging.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InMemoryChannelStatusBuilder extends InMemoryChannelStatusFluentImpl<InMemoryChannelStatusBuilder> implements VisitableBuilder<InMemoryChannelStatus,InMemoryChannelStatusBuilder> {

    InMemoryChannelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public InMemoryChannelStatusBuilder() { 
        this(true);
    }


    public InMemoryChannelStatusBuilder(Boolean validationEnabled) { 
        this(new InMemoryChannelStatus(), validationEnabled);
    }


    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new InMemoryChannelStatus(), validationEnabled);
    }


    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance) { 
        this(fluent, instance, true);
    }


    public InMemoryChannelStatusBuilder(InMemoryChannelStatusFluent<?> fluent,InMemoryChannelStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }


    public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance) { 
        this(instance,true);
    }


    public InMemoryChannelStatusBuilder(InMemoryChannelStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withAnnotations(instance.getAnnotations()); 
        this.withConditions(instance.getConditions()); 
        this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSubscribers(instance.getSubscribers()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.messaging.v1.EditableInMemoryChannelStatus build() {
        EditableInMemoryChannelStatus buildable = new EditableInMemoryChannelStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getDeadLetterChannel(),fluent.getObservedGeneration(),fluent.getSubscribers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InMemoryChannelStatusBuilder that = (InMemoryChannelStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
