package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface RevisionFluent<A extends RevisionFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public RevisionFluent.MetadataNested<A> withNewMetadata();
    public RevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RevisionFluent.MetadataNested<A> editMetadata();
    public RevisionFluent.MetadataNested<A> editOrNewMetadata();
    public RevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public RevisionSpec getSpec();
    public RevisionSpec buildSpec();
    public A withSpec(RevisionSpec spec);
    public Boolean hasSpec();
    public RevisionFluent.SpecNested<A> withNewSpec();
    public RevisionFluent.SpecNested<A> withNewSpecLike(RevisionSpec item);
    public RevisionFluent.SpecNested<A> editSpec();
    public RevisionFluent.SpecNested<A> editOrNewSpec();
    public RevisionFluent.SpecNested<A> editOrNewSpecLike(RevisionSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public RevisionStatus getStatus();
    public RevisionStatus buildStatus();
    public A withStatus(RevisionStatus status);
    public Boolean hasStatus();
    public RevisionFluent.StatusNested<A> withNewStatus();
    public RevisionFluent.StatusNested<A> withNewStatusLike(RevisionStatus item);
    public RevisionFluent.StatusNested<A> editStatus();
    public RevisionFluent.StatusNested<A> editOrNewStatus();
    public RevisionFluent.StatusNested<A> editOrNewStatusLike(RevisionStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<RevisionFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RevisionSpecFluent<RevisionFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RevisionStatusFluent<RevisionFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
