package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AwsSqsSourceStatusBuilder extends AwsSqsSourceStatusFluentImpl<AwsSqsSourceStatusBuilder> implements VisitableBuilder<AwsSqsSourceStatus,AwsSqsSourceStatusBuilder> {

    AwsSqsSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AwsSqsSourceStatusBuilder() { 
        this(true);
    }


    public AwsSqsSourceStatusBuilder(Boolean validationEnabled) { 
        this(new AwsSqsSourceStatus(), validationEnabled);
    }


    public AwsSqsSourceStatusBuilder(AwsSqsSourceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public AwsSqsSourceStatusBuilder(AwsSqsSourceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AwsSqsSourceStatus(), validationEnabled);
    }


    public AwsSqsSourceStatusBuilder(AwsSqsSourceStatusFluent<?> fluent,AwsSqsSourceStatus instance) { 
        this(fluent, instance, true);
    }


    public AwsSqsSourceStatusBuilder(AwsSqsSourceStatusFluent<?> fluent,AwsSqsSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public AwsSqsSourceStatusBuilder(AwsSqsSourceStatus instance) { 
        this(instance,true);
    }


    public AwsSqsSourceStatusBuilder(AwsSqsSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.EditableAwsSqsSourceStatus build() {
        EditableAwsSqsSourceStatus buildable = new EditableAwsSqsSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AwsSqsSourceStatusBuilder that = (AwsSqsSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
