
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "delivery",
    "numPartitions",
    "replicationFactor",
    "subscribers"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class KafkaChannelSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("delivery")
    private DeliverySpec delivery;
    /**
     * 
     * 
     */
    @JsonProperty("numPartitions")
    private Integer numPartitions;
    /**
     * 
     * 
     */
    @JsonProperty("replicationFactor")
    private Integer replicationFactor;
    /**
     * 
     * 
     */
    @JsonProperty("subscribers")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<SubscriberSpec> subscribers = new ArrayList<SubscriberSpec>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KafkaChannelSpec() {
    }

    /**
     * 
     * @param delivery
     * @param replicationFactor
     * @param subscribers
     * @param numPartitions
     */
    public KafkaChannelSpec(DeliverySpec delivery, Integer numPartitions, Integer replicationFactor, List<SubscriberSpec> subscribers) {
        this.delivery = delivery;
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
        this.subscribers = subscribers;
    }

    /**
     * 
     * 
     * @return
     *     The delivery
     */
    @JsonProperty("delivery")
    public DeliverySpec getDelivery() {
        return delivery;
    }

    /**
     * 
     * 
     * @param delivery
     *     The delivery
     */
    @JsonProperty("delivery")
    public void setDelivery(DeliverySpec delivery) {
        this.delivery = delivery;
    }

    /**
     * 
     * 
     * @return
     *     The numPartitions
     */
    @JsonProperty("numPartitions")
    public Integer getNumPartitions() {
        return numPartitions;
    }

    /**
     * 
     * 
     * @param numPartitions
     *     The numPartitions
     */
    @JsonProperty("numPartitions")
    public void setNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    /**
     * 
     * 
     * @return
     *     The replicationFactor
     */
    @JsonProperty("replicationFactor")
    public Integer getReplicationFactor() {
        return replicationFactor;
    }

    /**
     * 
     * 
     * @param replicationFactor
     *     The replicationFactor
     */
    @JsonProperty("replicationFactor")
    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    /**
     * 
     * 
     * @return
     *     The subscribers
     */
    @JsonProperty("subscribers")
    public List<SubscriberSpec> getSubscribers() {
        return subscribers;
    }

    /**
     * 
     * 
     * @param subscribers
     *     The subscribers
     */
    @JsonProperty("subscribers")
    public void setSubscribers(List<SubscriberSpec> subscribers) {
        this.subscribers = subscribers;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
