
package io.fabric8.knative.eventing.v1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "broker",
    "filter",
    "subscriber"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class TriggerSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("broker")
    private String broker;
    /**
     * 
     * 
     */
    @JsonProperty("filter")
    private TriggerFilter filter;
    /**
     * 
     * 
     */
    @JsonProperty("subscriber")
    private Destination subscriber;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public TriggerSpec() {
    }

    /**
     * 
     * @param filter
     * @param subscriber
     * @param broker
     */
    public TriggerSpec(String broker, TriggerFilter filter, Destination subscriber) {
        this.broker = broker;
        this.filter = filter;
        this.subscriber = subscriber;
    }

    /**
     * 
     * 
     * @return
     *     The broker
     */
    @JsonProperty("broker")
    public String getBroker() {
        return broker;
    }

    /**
     * 
     * 
     * @param broker
     *     The broker
     */
    @JsonProperty("broker")
    public void setBroker(String broker) {
        this.broker = broker;
    }

    /**
     * 
     * 
     * @return
     *     The filter
     */
    @JsonProperty("filter")
    public TriggerFilter getFilter() {
        return filter;
    }

    /**
     * 
     * 
     * @param filter
     *     The filter
     */
    @JsonProperty("filter")
    public void setFilter(TriggerFilter filter) {
        this.filter = filter;
    }

    /**
     * 
     * 
     * @return
     *     The subscriber
     */
    @JsonProperty("subscriber")
    public Destination getSubscriber() {
        return subscriber;
    }

    /**
     * 
     * 
     * @param subscriber
     *     The subscriber
     */
    @JsonProperty("subscriber")
    public void setSubscriber(Destination subscriber) {
        this.subscriber = subscriber;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
