package io.fabric8.knative.sources.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SinkBindingListFluent<A extends SinkBindingListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,SinkBinding item);
    public A setToItems(int index,SinkBinding item);
    public A addToItems(SinkBinding... items);
    public A addAllToItems(Collection<SinkBinding> items);
    public A removeFromItems(SinkBinding... items);
    public A removeAllFromItems(Collection<SinkBinding> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<SinkBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<SinkBinding> getItems();
    public List<SinkBinding> buildItems();
    public SinkBinding buildItem(int index);
    public SinkBinding buildFirstItem();
    public SinkBinding buildLastItem();
    public SinkBinding buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SinkBindingBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SinkBindingBuilder> predicate);
    public A withItems(List<SinkBinding> items);
    public A withItems(SinkBinding... items);
    public Boolean hasItems();
    public SinkBindingListFluent.ItemsNested<A> addNewItem();
    public SinkBindingListFluent.ItemsNested<A> addNewItemLike(SinkBinding item);
    public SinkBindingListFluent.ItemsNested<A> setNewItemLike(int index,SinkBinding item);
    public SinkBindingListFluent.ItemsNested<A> editItem(int index);
    public SinkBindingListFluent.ItemsNested<A> editFirstItem();
    public SinkBindingListFluent.ItemsNested<A> editLastItem();
    public SinkBindingListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SinkBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SinkBindingFluent<SinkBindingListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
