package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface GitLabSourceFluent<A extends GitLabSourceFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public GitLabSourceFluent.MetadataNested<A> withNewMetadata();
    public GitLabSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public GitLabSourceFluent.MetadataNested<A> editMetadata();
    public GitLabSourceFluent.MetadataNested<A> editOrNewMetadata();
    public GitLabSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public GitLabSourceSpec getSpec();
    public GitLabSourceSpec buildSpec();
    public A withSpec(GitLabSourceSpec spec);
    public Boolean hasSpec();
    public GitLabSourceFluent.SpecNested<A> withNewSpec();
    public GitLabSourceFluent.SpecNested<A> withNewSpecLike(GitLabSourceSpec item);
    public GitLabSourceFluent.SpecNested<A> editSpec();
    public GitLabSourceFluent.SpecNested<A> editOrNewSpec();
    public GitLabSourceFluent.SpecNested<A> editOrNewSpecLike(GitLabSourceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public GitLabSourceStatus getStatus();
    public GitLabSourceStatus buildStatus();
    public A withStatus(GitLabSourceStatus status);
    public Boolean hasStatus();
    public GitLabSourceFluent.StatusNested<A> withNewStatus();
    public GitLabSourceFluent.StatusNested<A> withNewStatusLike(GitLabSourceStatus item);
    public GitLabSourceFluent.StatusNested<A> editStatus();
    public GitLabSourceFluent.StatusNested<A> editOrNewStatus();
    public GitLabSourceFluent.StatusNested<A> editOrNewStatusLike(GitLabSourceStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<GitLabSourceFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitLabSourceSpecFluent<GitLabSourceFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitLabSourceStatusFluent<GitLabSourceFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
