package io.fabric8.knative.flows.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import java.lang.StringBuffer;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;

public class SequenceStepFluentImpl<A extends SequenceStepFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceStepFluent<A> {

    private DeliverySpecBuilder delivery;
    private KReferenceBuilder ref;
    private String uri;

    public SequenceStepFluentImpl() { 
    }


    public SequenceStepFluentImpl(SequenceStep instance) { 
        this.withDelivery(instance.getDelivery()); 
        this.withRef(instance.getRef()); 
        this.withUri(instance.getUri()); 
    }


    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@Deprecated public DeliverySpec getDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(DeliverySpec delivery) {
        _visitables.get("delivery").remove(this.delivery);
        if (delivery!=null){ this.delivery= new DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    public SequenceStepFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    public SequenceStepFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    public SequenceStepFluent.DeliveryNested<A> editDelivery() {
        return withNewDeliveryLike(getDelivery());
    }

    public SequenceStepFluent.DeliveryNested<A> editOrNewDelivery() {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new DeliverySpecBuilder().build());
    }

    public SequenceStepFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRef instead.
 * @return The buildable object.
 */
@Deprecated public KReference getRef() {
        return this.ref!=null?this.ref.build():null;
    }

    public KReference buildRef() {
        return this.ref!=null?this.ref.build():null;
    }

    public A withRef(KReference ref) {
        _visitables.get("ref").remove(this.ref);
        if (ref!=null){ this.ref= new KReferenceBuilder(ref); _visitables.get("ref").add(this.ref);} return (A) this;
    }

    public Boolean hasRef() {
        return this.ref != null;
    }

    public A withNewRef(String apiVersion,String kind,String name,String namespace) {
        return (A)withRef(new KReference(apiVersion, kind, name, namespace));
    }

    public SequenceStepFluent.RefNested<A> withNewRef() {
        return new RefNestedImpl();
    }

    public SequenceStepFluent.RefNested<A> withNewRefLike(KReference item) {
        return new RefNestedImpl(item);
    }

    public SequenceStepFluent.RefNested<A> editRef() {
        return withNewRefLike(getRef());
    }

    public SequenceStepFluent.RefNested<A> editOrNewRef() {
        return withNewRefLike(getRef() != null ? getRef(): new KReferenceBuilder().build());
    }

    public SequenceStepFluent.RefNested<A> editOrNewRefLike(KReference item) {
        return withNewRefLike(getRef() != null ? getRef(): item);
    }

    public String getUri() {
        return this.uri;
    }

    public A withUri(String uri) {
        this.uri=uri; return (A) this;
    }

    public Boolean hasUri() {
        return this.uri != null;
    }

    public A withNewUri(String arg1) {
        return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuilder arg1) {
        return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuffer arg1) {
        return (A)withUri(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SequenceStepFluentImpl that = (SequenceStepFluentImpl) o;
        if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
        if (ref != null ? !ref.equals(that.ref) :that.ref != null) return false;
        if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(delivery,  ref,  uri,  super.hashCode());
    }

    public class DeliveryNestedImpl<N> extends DeliverySpecFluentImpl<SequenceStepFluent.DeliveryNested<N>> implements SequenceStepFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DeliverySpecBuilder builder;

        DeliveryNestedImpl(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        DeliveryNestedImpl() {
            this.builder = new DeliverySpecBuilder(this);
        }

        public N and() {
             return (N) SequenceStepFluentImpl.this.withDelivery(builder.build());
        }

        public N endDelivery() {
             return and();
        }
    }


    public class RefNestedImpl<N> extends KReferenceFluentImpl<SequenceStepFluent.RefNested<N>> implements SequenceStepFluent.RefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KReferenceBuilder builder;

        RefNestedImpl(KReference item) {
            this.builder = new KReferenceBuilder(this, item);
        }

        RefNestedImpl() {
            this.builder = new KReferenceBuilder(this);
        }

        public N and() {
             return (N) SequenceStepFluentImpl.this.withRef(builder.build());
        }

        public N endRef() {
             return and();
        }
    }


}
