package io.fabric8.knative.serving.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ConfigurationListFluent<A extends ConfigurationListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Configuration item);
    public A setToItems(int index,Configuration item);
    public A addToItems(Configuration... items);
    public A addAllToItems(Collection<Configuration> items);
    public A removeFromItems(Configuration... items);
    public A removeAllFromItems(Collection<Configuration> items);
    public A removeMatchingFromItems(Predicate<ConfigurationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Configuration> getItems();
    public List<Configuration> buildItems();
    public Configuration buildItem(int index);
    public Configuration buildFirstItem();
    public Configuration buildLastItem();
    public Configuration buildMatchingItem(Predicate<ConfigurationBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ConfigurationBuilder> predicate);
    public A withItems(List<Configuration> items);
    public A withItems(Configuration... items);
    public Boolean hasItems();
    public ConfigurationListFluent.ItemsNested<A> addNewItem();
    public ConfigurationListFluent.ItemsNested<A> addNewItemLike(Configuration item);
    public ConfigurationListFluent.ItemsNested<A> setNewItemLike(int index,Configuration item);
    public ConfigurationListFluent.ItemsNested<A> editItem(int index);
    public ConfigurationListFluent.ItemsNested<A> editFirstItem();
    public ConfigurationListFluent.ItemsNested<A> editLastItem();
    public ConfigurationListFluent.ItemsNested<A> editMatchingItem(Predicate<ConfigurationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigurationFluent<ConfigurationListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
