package io.fabric8.knative.sources.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ContainerSourceListFluent<A extends ContainerSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ContainerSource item);
    public A setToItems(int index,ContainerSource item);
    public A addToItems(ContainerSource... items);
    public A addAllToItems(Collection<ContainerSource> items);
    public A removeFromItems(ContainerSource... items);
    public A removeAllFromItems(Collection<ContainerSource> items);
    public A removeMatchingFromItems(Predicate<ContainerSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ContainerSource> getItems();
    public List<ContainerSource> buildItems();
    public ContainerSource buildItem(int index);
    public ContainerSource buildFirstItem();
    public ContainerSource buildLastItem();
    public ContainerSource buildMatchingItem(Predicate<ContainerSourceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<ContainerSourceBuilder> predicate);
    public A withItems(List<ContainerSource> items);
    public A withItems(ContainerSource... items);
    public Boolean hasItems();
    public ContainerSourceListFluent.ItemsNested<A> addNewItem();
    public ContainerSourceListFluent.ItemsNested<A> addNewItemLike(ContainerSource item);
    public ContainerSourceListFluent.ItemsNested<A> setNewItemLike(int index,ContainerSource item);
    public ContainerSourceListFluent.ItemsNested<A> editItem(int index);
    public ContainerSourceListFluent.ItemsNested<A> editFirstItem();
    public ContainerSourceListFluent.ItemsNested<A> editLastItem();
    public ContainerSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<ContainerSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerSourceFluent<ContainerSourceListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
