package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface AwsSqsSourceSpecFluent<A extends AwsSqsSourceSpecFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public SecretKeySelector getAwsCredsSecret();
    public A withAwsCredsSecret(SecretKeySelector awsCredsSecret);
    public Boolean hasAwsCredsSecret();
    public A withNewAwsCredsSecret(String key,String name,Boolean optional);
    public String getQueueUrl();
    public A withQueueUrl(String queueUrl);
    public Boolean hasQueueUrl();
    public A withNewQueueUrl(String arg1);
    public A withNewQueueUrl(StringBuilder arg1);
    public A withNewQueueUrl(StringBuffer arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public ObjectReference getSink();
    public A withSink(ObjectReference sink);
    public Boolean hasSink();
}
