package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KafkaChannelListFluent<A extends KafkaChannelListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KafkaChannel item);
    public A setToItems(int index,KafkaChannel item);
    public A addToItems(KafkaChannel... items);
    public A addAllToItems(Collection<KafkaChannel> items);
    public A removeFromItems(KafkaChannel... items);
    public A removeAllFromItems(Collection<KafkaChannel> items);
    public A removeMatchingFromItems(Predicate<KafkaChannelBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KafkaChannel> getItems();
    public List<KafkaChannel> buildItems();
    public KafkaChannel buildItem(int index);
    public KafkaChannel buildFirstItem();
    public KafkaChannel buildLastItem();
    public KafkaChannel buildMatchingItem(Predicate<KafkaChannelBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<KafkaChannelBuilder> predicate);
    public A withItems(List<KafkaChannel> items);
    public A withItems(KafkaChannel... items);
    public Boolean hasItems();
    public KafkaChannelListFluent.ItemsNested<A> addNewItem();
    public KafkaChannelListFluent.ItemsNested<A> addNewItemLike(KafkaChannel item);
    public KafkaChannelListFluent.ItemsNested<A> setNewItemLike(int index,KafkaChannel item);
    public KafkaChannelListFluent.ItemsNested<A> editItem(int index);
    public KafkaChannelListFluent.ItemsNested<A> editFirstItem();
    public KafkaChannelListFluent.ItemsNested<A> editLastItem();
    public KafkaChannelListFluent.ItemsNested<A> editMatchingItem(Predicate<KafkaChannelBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaChannelFluent<KafkaChannelListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
